<?php  
/**
 * Set language short cooe here (ISO 639-1 Code)
 * See Language Code Reference 
 * http://www.w3schools.com/tags/ref_language_codes.asp
 */  
define('APP_LANGUAGE_SHORT_CODE','en'); 

/**
 * Set the text direction: (ltr or rtl)
 * ltr - the writing direction is left-to-right. This is default
 * rtl - the writing direction is right-to-left
 */
define('APP_LANGUAGE_TEXT_DIRECTION','ltr');
 
define('TEXT_FIELDTYPE_INPUT_TITLE','Input Field');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_TITLE','Input Numeric Field');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_COMMENTS_TITLE','Input Numeric Field in Comments');
define('TEXT_FIELDTYPE_INPUT_URL_TITLE','Input URL Field');
define('TEXT_FIELDTYPE_INPUT_DATE_TITLE','Date with calendar picker');
define('TEXT_FIELDTYPE_INPUT_DATETIME_TITLE','Date with calendar and time picker');
define('TEXT_FIELDTYPE_INPUT_FILE_TITLE','File Field');
define('TEXT_FIELDTYPE_ATTACHMENTS_TITLE','Attachments');
define('TEXT_FIELDTYPE_TEXTAREA_TITLE','Textarea');
define('TEXT_FIELDTYPE_TEXTAREA_WYSIWYG_TITLE','Textarea with WYSIWYG editor');
define('TEXT_FIELDTYPE_DROPDOWN_TITLE','Dropdown list');
define('TEXT_FIELDTYPE_DROPDOWN_MULTIPLE_TITLE','Dropdown multiselect');
define('TEXT_FIELDTYPE_CHECKBOXES_TITLE','Checkboxes');
define('TEXT_FIELDTYPE_RADIOBOXES_TITLE','Radioboxes');
define('TEXT_FIELDTYPE_FORMULA_TITLE','MySQL Formula');
define('TEXT_FIELDTYPE_USERS_TITLE','Users');
define('TEXT_FIELDTYPE_GROUPEDUSERS_TITLE','Grouped Users');
define('TEXT_FIELDTYPE_ENTITY_TITLE','Entity');
define('TEXT_FIELDTYPE_ACTION_TITLE','Action');
define('TEXT_FIELDTYPE_ID_TITLE','ID');
define('TEXT_FIELDTYPE_DATEADDED_TITLE','Date Added');
define('TEXT_FIELDTYPE_CREATEDBY_TITLE','Created By');
define('TEXT_FIELDTYPE_USER_STATUS_TITLE','User Status');
define('TEXT_FIELDTYPE_USER_ACCESSGROUP_TITLE','Access Group');
define('TEXT_FIELDTYPE_USER_FIRSTNAME_TITLE','First Name');
define('TEXT_FIELDTYPE_USER_LASTNAME_TITLE','Last Name');
define('TEXT_FIELDTYPE_USER_EMAIL_TITLE','User Email');
define('TEXT_FIELDTYPE_USER_PHOTO_TITLE','Photo');
define('TEXT_FIELDTYPE_USER_LANGUAGE_TITLE','Language');
define('TEXT_FIELDTYPE_USER_USERNAME_TITLE','Username');
define('TEXT_FIELDTYPE_USER_PASSWORD_TITLE','Password');
define('TEXT_FIELDTYPE_USER_SKIN_TITLE','Skin');
define('TEXT_FIELDTYPE_PROGRESS_TITLE','Progress');

define('TEXT_FIELDTYPE_INPUT_TOOLTIP','Simple input text field.');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_TOOLTIP','This field uses for numbers.');
define('TEXT_FIELDTYPE_INPUT_NUMERIC_COMMENTS_TOOLTIP','This field is for display in the comments only. The value of this field is the sum of numbers being entered in the comments.');
define('TEXT_FIELDTYPE_INPUT_URL_TOOLTIP','Input text field for urls. Fields content will be automatically converted to url.');
define('TEXT_FIELDTYPE_INPUT_DATE_TOOLTIP','Calendar picker will be automatically added to this field.');
define('TEXT_FIELDTYPE_INPUT_DATETIME_TOOLTIP','Calendar and time picker will be automatically added to this field.');
define('TEXT_FIELDTYPE_INPUT_FILE_TOOLTIP','Allows upload single file.');
define('TEXT_FIELDTYPE_ATTACHMENTS_TOOLTIP','Allows upload multiple files');
define('TEXT_FIELDTYPE_TEXTAREA_TOOLTIP','Simple textarea field.');
define('TEXT_FIELDTYPE_TEXTAREA_WYSIWYG_TOOLTIP','WYSIWYG editor will be automatically added to this field.');
define('TEXT_FIELDTYPE_DROPDOWN_TOOLTIP','Drop-down list with options that you can define by clicking on field name once it created.');
define('TEXT_FIELDTYPE_DROPDOWN_MULTIPLE_TOOLTIP','Drop-down list with live search and the ability to select multiple values.');
define('TEXT_FIELDTYPE_CHECKBOXES_TOOLTIP','Checkboxes list with options that you can define by clicking on field name once it created.');
define('TEXT_FIELDTYPE_RADIOBOXES_TOOLTIP','Radioboxes list with options that you can define by clicking on field name once it created.');
define('TEXT_FIELDTYPE_FORMULA_TOOLTIP','Value of this field will be calculated by formula entered below.');
define('TEXT_FIELDTYPE_USERS_TOOLTIP','Special field allows you assign users to item that allows configure user access to item.');
define('TEXT_FIELDTYPE_GROUPEDUSERS_TOOLTIP','Special field allows you assign group of users to item that allows configure user access to item.');
define('TEXT_FIELDTYPE_ENTITY_TOOLTIP','Special field allows you link items from exist entity.');
define('TEXT_FIELDTYPE_USER_PASSWORD_TOOLTIP','Leave blank and password will be generated automatically.');
define('TEXT_FIELDTYPE_PROGRESS_TOOLTIP','Automatically creates a list from 1 to 100');

define('TEXT_BUTTON_LOGIN','Login');
define('TEXT_BUTTON_SAVE','Save');
define('TEXT_BUTTON_CLOSE','Close');
define('TEXT_BUTTON_EDIT','Edit');
define('TEXT_BUTTON_DELETE','Delete');
define('TEXT_BUTTON_CHANGE','Change');
define('TEXT_BUTTON_ADD_FORM_TAB','Add New Form Tab');
define('TEXT_BUTTON_SORT_FORM_TAB','Sort Form Tabs');
define('TEXT_BUTTON_PREVIEW_FORM','Preview Form');
define('TEXT_BUTTON_ADD_NEW_FIELD','Add New Field');
define('TEXT_BUTTON_ADD_NEW_VALUE','Add New Value');
define('TEXT_BUTTON_RESTORE_PASSWORD','Restore Password');
define('TEXT_BUTTON_SEARCH','Search');
define('TEXT_BUTTON_CREATE_BACKUP','Create Backup');
define('TEXT_BUTTON_DOWNLOAD','Download');
define('TEXT_BUTTON_RESTORE','Restore');
define('TEXT_BUTTON_ADD_COMMENT','Add Comment');
define('TEXT_BUTTON_ADD_NEW_REPORT','Add Report');
define('TEXT_BUTTON_CONFIGURE_FILTERS','Filters');
define('TEXT_BUTTON_CONFIGURE_SORTING','Sorting');
define('TEXT_BUTTON_ADD_NEW_REPORT_FILTER','Add Filter');
define('TEXT_BUTTON_CREATE_SUB_VALUE','Add Sub Value');
define('TEXT_BUTTON_REMOVE_ALL_FILTERS','Remove All Filters');
define('TEXT_BUTTON_REMOVE_FILTER','Remove Filter');
define('TEXT_BUTTON_CONTINUE','Continue');
define('TEXT_BUTTON_IMPORT','Import');
define('TEXT_BUTTON_BIND','Bind');
define('TEXT_BUTTON_CREATE','Create');

define('TEXT_ERROR','Error:');
define('TEXT_ERROR_GENERAL','Some fields are required. They have been highlighted above.');
define('TEXT_ERROR_REQUIRED','This field is required!');
define('TEXT_ERROR_FILE_EXTENSION','This file type is not allowed.');
define('TEXT_ERROR_REQUIRED_NUMBER','Please enter a valid number.');
define('TEXT_ERROR_USEREMAL_EXIST','User Email already exist!');
define('TEXT_ERROR_USERNAME_EXIST','Username already exist!');
define('TEXT_ERROR_USEREMAL_EMPTY','User Eamil can\'t be empty');
define('TEXT_ERROR_USERNAME_EMPTY','Username can\'t be empty');
define('TEXT_ERROR_FORMULA_CALCULATION','Entity "%s". Field "%s" [%s]. Error of formula calculation "%s".');
define('TEXT_ERROR_USER_DELETE','You can\'t delete yourself');
define('TEXT_ERROR_PASSOWRD_CONFIRMATION','The Password Confirmation must match your Password.');
define('TEXT_ERROR_PASSOWRD_LENGTH','Your Password must contain a minimum of ' . CFG_PASSWORD_MIN_LENGTH . ' characters.');
define('TEXT_ERROR_DEFAULT_LDAP_GROUP','Default users access group for LDAP users is not setup. LDAP login is not allowed.');
define('TEXT_ERROR_ITEM_HAS_SUB_ITEM','You can\'t delete this item because it has sub items in entities: %s');
define('TEXT_ERROR_DELETE_USER_GROUP','You can\'t delete this group because there are %s users assigned to this group');

define('TEXT_MENU_DASHBOARD','Dashboard');
define('TEXT_MENU_LOGIN','Login');
define('TEXT_MENU_LDAP_LOGIN','LDAP Login');
define('TEXT_MENU_CONFIGURATION','Configuration');
define('TEXT_MENU_COMMON_SETTINGS','Common Settings');
define('TEXT_MENU_APPLICATION','Application');
define('TEXT_MENU_EMAIL_OPTIONS','Email Options');
define('TEXT_MENU_LDAP','LDAP');
define('TEXT_MENU_LOGIN_PAGE','Login Page');
define('TEXT_MENU_APPLICATION_STRUCTURE','Application Structure');
define('TEXT_MENU_USERS_ACCESS_GROUPS','Users Access Groups');
define('TEXT_MENU_TOOLS','Tools');
define('TEXT_MENU_PLUGINS','Plugins');
define('TEXT_MENU_BACKUP','Database Backup');
define('TEXT_MENU_SERVER_INFO','Server Info');
define('TEXT_MENU_SUPPORT','Support');
define('TEXT_MENU_REPORT_FORUM','Forum');
define('TEXT_MENU_CONTACT_US','Contact Us');
define('TEXT_MENU_EXTENDED_VERSION','Extended Version');
define('TEXT_MENU_ENTITIES_LIST','Entities List');
define('TEXT_MENU_IMPORT_DATA','Import Data');
define('TEXT_MENU_CHECK_VERSION','Check Version');
define('TEXT_MENU_EXTENSION','Extension');

define('TEXT_HEADING_LDAP','LDAP Configuration');
define('TEXT_LDAP_USE','Use LDAP Login');
define('TEXT_LDAP_SERVER_NAME','LDAP server name');
define('TEXT_LDAP_SERVER_NAME_NOTES','If using LDAP this is the hostname or IP address of the LDAP server. Alternatively you can specify a URL like ldap://hostname:port/');
define('TEXT_LDAP_SERVER_PORT','LDAP server port');
define('TEXT_LDAP_SERVER_PORT_NOTES','Optionally you can specify a port which should be used to connect to the LDAP server instead of the default port 389.');
define('TEXT_LDAP_BASE_DN','LDAP base dn');
define('TEXT_LDAP_BASE_DN_NOTES','This is the Distinguished Name, locating the user information, e.g. o=My Company,c=US.');  
define('TEXT_LDAP_UID','LDAP uid');
define('TEXT_LDAP_UID_NOTES','This is the key under which to search for a given login identity, e.g. uid, sn, etc.');
define('TEXT_LDAP_USER_FILTER','LDAP user filter');
define('TEXT_LDAP_USER_FILTER_NOTES','Optionally you can further limit the searched objects with additional filters.<br>For example objectClass=posixGroup would result in the use of (&(uid=$username)(objectClass=posixGroup))<br>Group membership verification filter: (memberOf=cn=TestGroup,cn=Users,dc=MyCompany,dc=org)');
define('TEXT_LDAP_EMAIL_ATTRIBUTE','LDAP Email attribute');
define('TEXT_LDAP_EMAIL_ATTRIBUTE_NOTES','Set this to the name of your user entry Email attribute (if one exists) in order to automatically set the e-mail address for new users.<br>User email is required for qdPM and if it\'s not exist qdPM atumatically assign email like username@localhost.com');
define('TEXT_LDAP_USER_DN','LDAP user dn');
define('TEXT_LDAP_USER_DN_NOTES','Leave blank to use anonymous binding. If filled in uses the specified distinguished name on login attempts to find the correct user, e.g. uid=Username,ou=MyUnit,o=MyCompany,c=US. ');
define('TEXT_LDAP_PASSWORD','LDAP password');
define('TEXT_LDAP_PASSWORD_NOTES','Leave blank to use anonymous binding. Otherwise fill in the password for the above user. <br><b>Warning:</b> This password will be stored as plain text in the database visible to everybody who can access your database or view this configuration page.');
define('TEXT_LDAP_IS_NOT_ENABLED','LDAP is not enabled');
define('TEXT_LDAP_ERROR_NOT_AVAILABLE','PHP LDAP extension not available. Check your server configuration.');
define('TEXT_LDAP_ERROR_CONNECTION','Could not connect to LDAP server.');
define('TEXT_LDAP_ERROR_BINDING','Binding to LDAP server failed with specified user/password.');
define('TEXT_LDAP_ERROR_INCORRECT_PASSWORD','You have specified an incorrect password. Please check your password and try again.');
define('TEXT_LDAP_ERROR_INCORRECT_USERNAME','You have specified an incorrect username. Please check your username and try again.');

define('TEXT_HEADING_EMAIL_OPTIONS','Email Options');  
define('TEXT_EMAIL_USE_NOTIFICATION','Use email notification');
define('TEXT_EMAIL_SUBJECT_LABEL','Email Subject Label');
define('TEXT_EMAIL_AMOUNT_PREVIOUS_COMMENTS','Amount previous comments in email');
define('TEXT_EMAIL_COPY_SENDER','Copy Sender?');
define('TEXT_EMAIL_SEND_FROM_SINGLE','Send all emails from Support Department Email Address');
define('TEXT_EMAIL_ADDRESS_FROM','Email address from');
define('TEXT_EMAIL_NAME_FROM','Name from');
define('TEXT_EMAIL_USE_SMTP','Use SMTP');
define('TEXT_EMAIL_SMTP_SERVER','SMTP Server');
define('TEXT_EMAIL_SMTP_PORT','SMTP Port');
define('TEXT_EMAIL_SMTP_ENCRYPTION','SMTP Encryption');
define('TEXT_EMAIL_SMTP_LOGIN','SMTP Login');
define('TEXT_EMAIL_SMTP_PASSWORD','SMTP Password');    
define('TEXT_EMAIL_SMTP_CONFIGURATION','SMTP Configuration');
define('TEXT_HEADING_USER_REGISTRATION_EMAIL','User Registration Email');
define('TEXT_MENU_USER_REGISTRATION_EMAIL','User Registration Email');
define('TEXT_NEW_USER_DEFAULT_EMAIL_SUBJECT','Your account has been created in ' . CFG_APP_NAME);
define('TEXT_REGISTRATION_EMAIL_SUBJECT','Subject:');
define('TEXT_REGISTRATION_EMAIL_SUBJECT_NOTE','Default subject is :"' . TEXT_NEW_USER_DEFAULT_EMAIL_SUBJECT);
define('TEXT_REGISTRATION_EMAIL_BODY','Body:');
define('TEXT_REGISTRATION_EMAIL_BODY_NOTE','Login details will be included automatically at the bottom of email body');

define('TEXT_NAV_ENTITY','Entity');
define('TEXT_NAV_GENERAL_CONFIG','General Configuration');
define('TEXT_NAV_FIELDS_CONFIG','Fields Configuration');
define('TEXT_NAV_FIELDS_CHOICES_CONFIG','Fields Choices');
define('TEXT_NAV_VIEW_CONFIG','View Configuration');
define('TEXT_NAV_FORM_CONFIG','Form Configuration');
define('TEXT_NAV_LISTING_CONFIG','Listing Configuration');
define('TEXT_NAV_LISTING_FILTERS_CONFIG','Default Filters');
define('TEXT_NAV_USER_PUBLIC_PROFILE_CONFIG','Public Profile');
define('TEXT_NAV_ACCESS_CONFIG','Access');
define('TEXT_NAV_ENTITY_ACCESS','Access Configuration');
define('TEXT_NAV_FIELDS_ACCESS','Fields Access');
define('TEXT_NAV_SWITCH','Switch To');
define('TEXT_NAV_COMMENTS_CONFIG','Comments Configuration');
define('TEXT_NAV_COMMENTS_ACCESS','Comments Access');
define('TEXT_NAV_COMMENTS_FIELDS','Comments Form');
define('TEXT_NAV_COMMENTS_FORM_CONFIG','Comments Form Configuration');

define('TEXT_USERNAME','Username');
define('TEXT_PASSWORD','Password');
define('TEXT_ARE_YOU_SURE','Are you sure?');
define('TEXT_CONFIGURATION','Configuration');
define('TEXT_WARNING','Warning');
define('TEXT_DELETE','Delete');
define('TEXT_YES','Yes');
define('TEXT_NO','No');
define('TEXT_NAME','Name');
define('TEXT_DESCRIPTION','Description');
define('TEXT_SORT_ORDER','Sort Order');
define('TEXT_HEADING_DELETE','Delete?');
define('TEXT_DEFAULT_DELETE_CONFIRMATION','Are you sure you want to delete "%s"?');
define('TEXT_NO_RECORDS_FOUND','No Records Found');
define('TEXT_DISPLAY_NUMBER_OF_ITEMS', 'Displaying <nobr><strong>%s</strong> to <strong>%s</strong></nobr> <nobr>(of <strong>%s</strong> items)</nobr>');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Previous Page');
define('PREVNEXT_TITLE_NEXT_PAGE', 'Next Page');
define('PREVNEXT_TITLE_PAGE_NO', 'Page %d');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Previous Set of %d Pages');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Next Set of %d Pages');
define('TEXT_WARN_DELETE_SUCCESS','Record <b>%s</b> was successfully deleted');
define('TEXT_WIDHT','Width');
define('TEXT_HEIGHT','Height');
define('TEXT_ADD','Add');
define('TEXT_VIEW_ALL','View All');
define('TEXT_INFO','Info');
define('TEXT_ACTION','Action');
define('TEXT_ID','#');
define('TEXT_DATE_ADDED','Date Added');
define('TEXT_CREATED_BY','Created By');
define('TEXT_SEARCH','Search');
define('TEXT_SEARCH_RESULT_FOR','Search result for: <b>%s</b>');
define('TEXT_ACTIVE','Active');
define('TEXT_INACTIVE','Inactive');
define('TEXT_IS_DEFAULT','Is default?');
define('TEXT_IS_LDAP_DEFAULT','Is LDAP default?');
define('TEXT_ADMINISTRATOR','Administrator');

define('TEXT_LOGIN_DETAILS','Login Details'); 
define('TEXT_MY_ACCOUNT','My Account');
define('TEXT_CHANGE_SKIN','Change Skin');
define('TEXT_CHANGE_PASSWORD','Change Password');
define('TEXT_LOGOFF','Logoff');
define('TEXT_EMAIL','Email');
define('TEXT_ENTITIES_HEADING','Application Entities');
define('TEXT_ADD_NEW_ENTITY','Add New Entity');
define('TEXT_HEADING_ENTITY_IFNO','Entity Info');
define('TEXT_HEADING_ENTITY_CONFIGURATION','Entity Configuration');
define('TEXT_HEADING_NEW_FORM_TAB','New Form Tab');
define('TEXT_HEADING_EDIT_FORM_TAB','Edit Form Tab');
define('TEXT_CREATE_SUB_ENTITY','Create Sub Entity');
define('TEXT_LISTING_CFG_INFO','Just move fields between the boxes to include or exclude fields in listing.');
define('TEXT_FIELDS_IN_LISTING','Fields in listing');
define('TEXT_FIELDS_EXCLUDED_FROM_LISTING','Excluded from listing');
define('TEXT_WARN_DELETE_ENTITY_USERS','You can\'t delete entity <b>%s</b> because this is reserved entity.');
define('TEXT_WARN_DELETE_ENTITY_HAS_PARENT','You can\'t delete entity <b>%s</b> because it has sub entity. Delete sub entity first, please.');
define('TEXT_WARN_DELETE_ENTITY_HAS_ITEMS','You can\'t delete entity <b>%s</b> because it has sub items. Delete all items first, please.');
define('TEXT_WARN_DELETE_FROM_TAB','You can\'t delete Form Tab <b>%s</b> because there are some fields assign to this tab.<br> Move fields to other Form Tab and try again.');
define('TEXT_TITLES','Titles');
define('TEXT_MENU_TITLE','Menu Title');
define('TEXT_MENU_TITLE_TOOLTIP','This value will be used in main navigation menu.');
define('TEXT_LISTING_HEADING','Listing Heading');
define('TEXT_LISTING_HEADING_TOOLTIP','This value will be used in items listing.');
define('TEXT_WINDOW_HEADING','Window Heading');
define('TEXT_WINDOW_HEADING_TOOLTIP','This value will be used in popup window when insert or edit item.');
define('TEXT_INSERT_BUTTON_TITLE','Insert Button');
define('TEXT_INSERT_BUTTON_TITLE_TOOLTIP','This value will be used in button to insert item.');
define('TEXT_EMAIL_SUBJECT_NEW_ITEM','Email Subject for new item');
define('TEXT_EMAIL_SUBJECT_NEW_ITEM_TOOLTIP','This Subject will be used when you create a new item');
define('TEXT_EMAIL_SUBJECT_NEW_COMMENT','Email Subject for new comment');
define('TEXT_EMAIL_SUBJECT_NEW_COMMENT_TOOLTIP','This Subject will be used when you create comment');
define('TEXT_DEFAULT_EMAIL_SUBJECT_NEW_ITEM','New Item:');
define('TEXT_DEFAULT_EMAIL_SUBJECT_NEW_COMMENT','New Comment for:');
define('TEXT_COMMENTS_TITLE','Comments');
define('TEXT_USE_COMMENTS','Use Comments');
define('TEXT_USE_COMMENTS_TOOLTIP','Allows users  added comments to items. Once this opiton enabled check Comments Coinfiguraiton in left menu.');
define('TEXT_COMMENTS_ACCESS_INFO','Configure which users groups will have access to comments.');
define('TEXT_COMMENT_IFNO','Comment');
define('TEXT_COMMENT_WAS_DELETED','Comment was deleted');
define('TEXT_COMMENTS_FORM_CFG_INFO','You can configure which fields will be available in comments form to update item.');
define('TEXT_AVAILABLE_FIELS','Available Fields');
define('TEXT_FIELDS_IN_COMMENTS_FORM','Fields in Comments Form');
define('TEXT_HEADING_FIELD_IFNO','Field Info');
define('TEXT_GENERAL_INFO','General Info');
define('TEXT_FORM_TAB','Form Tab');
define('TEXT_TOOLTIP','Tooltip');
define('TEXT_SHORT_NAME','Short Name');
define('TEXT_IS_HEADING','Is Heading?');
define('TEXT_IS_REQUIRED','Is Required?');
define('TEXT_TYPE','Type');
define('TEXT_REQUIRED_MESSAGE','Message');
define('TEXT_FORM_TAB_INFO','Form Tab where field will be stored.');
define('TEXT_FIELD_NAME_INFO','Name of Field. Enter the Short Name to replace the Name where Name is too long.');
define('TEXT_FIELD_SHORT_NAME_INFO','If you enter a Short Name then it will be used in the Listing.');
define('TEXT_IS_HEADING_INFO','If field is heading then field value will used in entity info page heading  and in email subject. Only one field can be set as heading.');
define('TEXT_FIELD_TYPE_INFO','Choose the type of data this field is to display.');
define('TEXT_IS_REQUIRED_INFO','Check this option if field is required. By default user will see  message "This field is required!". Also you can enter custom message below.');
define('TEXT_REQUIRED_MESSAGE_INFO','Default message "This field is required!" will be replaced by custom message.');
define('TEXT_TOOLTIP_INFO','If you enter tooltip text then it will be displayed on entity form just like you see it now.');
define('TEXT_FORMULA','Formula');
define('TEXT_FORMULA_TIP','Use [Field ID] to setup field value in formula. Example: ([36]+[54])/2. Where 36 and 54 are ID of numeric fields. <a href="https://docs.rukovoditel.net/index.php?p=25" target="_blank"><u>See more examples.</u></a>');
define('TEXT_ENTER_WIDTH','Select the width of the field');
define('TEXT_INPTUT_SMALL','Small Field');
define('TEXT_INPUT_MEDIUM','Medium field');
define('TEXT_INPUT_LARGE','Large field');
define('TEXT_INPUT_XLARGE','Extra large field');
define('TEXT_ENTER_HEIGHT','Enter Height in pixels. For example 60. Or leave empty to use default value.');
define('TEXT_HEADING_VALUE_IFNO','Info');
define('TEXT_BACKGROUND_COLOR','Background Color');
define('TEXT_PARENT','Parent');
define('TEXT_CHOICES_PARENT_INFO','Select Parent Value');
define('TEXT_CHOICES_NAME_INFO','Enter the Name');
define('TEXT_CHOICES_IS_DEFAULT_INFO','This value will be selected by default when you create item.');
define('TEXT_CHOICES_BACKGROUND_COLOR_INFO','Value in listing will be displayed with background color.');
define('TEXT_CHOICES_SORT_ORDER_INFO','Enter Sort Order to sort values in list.');
define('TEXT_CHOICES_USERS_INFO','Select users that will be assigned to this value');
define('TEXT_ALLOW_SEARCH','Use for search?');
define('TEXT_ALLOW_SEARCH_TIP','This option allows you use this fields for search items.');
define('TEXT_USERS_GROUPS','Users Groups');
define('TEXT_VIEW_ACCESS','View');
define('TEXT_VIEW_ONLY_ACCESS','View Only');
define('TEXT_CREATE_ONLY_ACCESS','Create Only');
define('TEXT_CREATE_ACCESS','Create');
define('TEXT_UPDATE_ACCESS','Update');
define('TEXT_DELETE_ACCESS','Delete');
define('TEXT_VIEW_ASSIGNED_ACCESS','View Assigned Only');
define('TEXT_ACCESS_UPDATED','Access Updated!');
define('TEXT_ENTITY_ACCESS_INFO','On this page you can configure access to each users group.<br>To give access just select "View" option and after this you can configure Create/Update/Delete access.<br>"View Assigned Only" means entity should have field with type "Users" and users will have access to itmes where they are assigned only.');
define('TEXT_ADMINISTRATOR_FULL_ACCESS','Administrator have full access');
define('TEXT_FIELDS','Fields');
define('TEXT_ACCESS','Access');
define('TEXT_HEADING_APPLICATION','Application Settings');
define('TEXT_APPLICATION_NAME','Name of application');
define('TEXT_APPLICATION_SHORT_NAME','Short name of application');
define('TEXT_APPLICATION_LOGO','Logo');
define('TEXT_APPLICATION_TIMEZONE','Time Zone');  
define('TEXT_ROWS_PER_PAGE','Rows Per Page');
define('TEXT_DATE_FORMAT','Date Format');
define('TEXT_DATETIME_FORMAT','Date/Time Format');
define('TEXT_DATE_FORMAT_IFNO','more about date format see <a target="_blanck" href="http://php.net/manual/en/function.date.php">format a local time/date</a>');
define('TEXT_MIN_PASSWORD_LENGTH','Minimum length of User password');
define('TEXT_HEADING_LOGIN_PAGE_CONFIGURATION','Login Page Configuration');
define('TEXT_LOGIN_PAGE_HEADING','Page Heading');
define('TEXT_LOGIN_PAGE_CONTENT','Page Description');
define('TEXT_LOGIN_PAGE_BACKGROUND','Background Image');
define('TEXT_LOGIN_PAGE_BACKGROUND_INFO','The image is stretched to the full width of the page. It is recommended to use an image 1920x1200');
define('TEXT_CONFIGURATION_UPDATED','Configuration successfully updated.');
define('TEXT_HEADING_USER_GROUP_IFNO','Group Info');
define('TEXT_HEADING_USERS_ACCESS_GROUPS','Users Access Groups');
define('TEXT_ADD_NEW_USER_GROUP','Add New Group');
define('TEXT_SORT_GROUPS','Sort Groups');
define('TEXT_VIEW_ONLY','View Only');
define('TEXT_HIDE','Hide');
define('TEXT_HEADING_LOGIN','Login');
define('TEXT_HEADING_LDAP_LOGIN','LDAP Login');
define('TEXT_HEADING_CHANGE_PASSWORD','Change Password');
define('TEXT_NEW_PASSWORD','New Password');
define('TEXT_PASSWORD_CONFIRMATION','Password Confirmation');
define('TEXT_PASSWORD_UPDATED','Your password has been successfully updated.');
define('TEXT_USER_PASSWORD_UPDATED','User password has been successfully updated.');
define('TEXT_USER_NOT_FOUND','No match for Username and/or Password.');
define('TEXT_USER_IS_NOT_ACTIVE','Your account is not active.');
define('TEXT_PASSWORD_FORGOTTEN','Password forgotten?');
define('TEXT_HEADING_RESTORE_PASSWORD','Restore Password');
define('TEXT_RESTORE_PASSWORD_EMAIL_SUBJECT',CFG_APP_NAME . ' - New Password');  
define('TEXT_RESTORE_PASSWORD_EMAIL_BODY','A new password was requested. Your new login details to ' . CFG_APP_NAME . ' are:');
define('TEXT_RESTORE_PASSWORD_SUCCESS','A new password has been sent to your e-mail address.');
define('TEXT_REMEMBER_ME','Remember Me');
define('TEXT_HEADING_MY_ACCOUNT','My Account');
define('TEXT_ACCOUNT_UPDATED','Account Updated');
define('TEXT_ACCESS_FORBIDDEN','Access Forbidden');
define('TEXT_ACCESS_FORBIDDEN_MESSAGE','Sorry, you don\'t have access to this page.');
define('TEXT_NO_ACCESS','You don\'t have access');
define('TEXT_BUTTON_INFO','Info');
define('TEXT_RESET_SEARCH','Reset Search');
define('TEXT_HEADING_DB_BACKUP','Database Backup');
define('TEXT_BACKUP_CREATED','Backup Created');
define('TEXT_DOWNLOAD','Download');
define('TEXT_RESTORE','Restore');
define('TEXT_BACKUP_DELETED','Backup file was deleted');
define('TEXT_FILE_NOT_FOUD','File not found');
define('TEXT_DB_RESTORE_CONFIRMATION','Are you sure you want to restore data from "%s" ? <br><b>Note:</b> all exist data will be replaced.');
define('TEXT_BACKUP_RESTORED','Database Backup Restored');
define('TEXT_COMMENTS','Comments');
define('TEXT_ATTACHMENTS','Attachments');
define('TEXT_REPORTS','Reports');
define('TEXT_STANDARD_REPORTS','Standard Reports');
define('TEXT_HEADING_REPORTS','Reports');
define('TEXT_IN_MENU','In Menu');
define('TEXT_IN_DASHBOARD','In Dashboard');
define('TEXT_HEADING_REPORTS_IFNO','Report Info');
define('TEXT_WARN_DELETE_REPORT_SUCCESS','Report Deleted');
define('TEXT_REPORT_ENTITY','Entity');
define('TEXT_VIEW','View');
define('TEXT_PLEASE_WAYIT_FILES_LOADING','Please wait. Files are loading.');
define('TEXT_ADD_ATTACHMENTS','Add Attachments');
define('TEXT_HEADING_SERVER_INFORMATION','Server Information');
define('TEXT_HEADING_FILTERS_FOR_REPORT','Filters for report:');
define('TEXT_HEADING_FILTERS_FOR','Filters for:');
define('TEXT_HEADING_REPORTS_SORTING','Sorting Configuration');
define('TEXT_FIELDS_FOR_SORTING','Fields for sorting');
define('TEXT_FIELDS_EXCLUDED_FROM_SORTING','Exclude from sorting');
define('TEXT_LISTING_SORTING_CFG_INFO','Just move fields between the boxes to include or exclude fields for sorting.<br>Click on arrow icon to change sorting condition.');
define('TEXT_REPORT_NOT_FOUND','Report not found!');
define('TEXT_FIELD','Field');
define('TEXT_VALUES','Values');
define('TEXT_HEADING_REPORTS_FILTER_IFNO','Filter Info');
define('TEXT_SELECT_FIELD','Select Field');
define('TEXT_WARN_DELETE_FILTER_SUCCESS','Filter deleted');
define('TEXT_WARN_DELETE_ALL_FILTERS_SUCCESS','Filters deleted');
define('TEXT_FILTERS_CONDITION','Condition');
define('TEXT_FILTERS_CONDITION_TOOLTIP','Include or Exclude selected values.');
define('TEXT_CONDITION_INCLUDE','Include');
define('TEXT_CONDITION_EXCLUDE','Exclude');
define('TEXT_FILTERS_NUMERIC_FIELDS_TOOLTIP','Example of Values: <ul><li>1|2|3<br>means value=1 or value=2 or value=3</li><li>>5&<10<br> means value>5 and value<10</li><li>>=5&!=10<br> means value>5 and value!=10</li></ul>');
define('TEXT_DISPLAY_USERS_AS','Display as');
define('TEXT_DISPLAY_USERS_AS_DROPDOWN','Dropdown');
define('TEXT_DISPLAY_USERS_AS_CHECKBOXES','Checkboxes');
define('TEXT_DISPLAY_USERS_AS_DROPDOWN_MULTIPLE','Dropdown with multiselect');
define('TEXT_DISPLAY_USERS_AS_TOOLTIP','Use Checkboxes for mulitple users select');
define('TEXT_USERS_LIST','Users List');
define('TEXT_FILTER_BY_DAYS','Filter By Days');
define('TEXT_FILTER_BY_DAYS_TOOLTIP','You can use "+1" and it means "Today+1". There rule can be "-1". Also you can set several days like "+1&2&3".');
define('TEXT_FILTER_BY_DATES','Filter By Dates');
define('TEXT_FILTER_BY_DATES_TOOLTIP','Set From/To dates.');
define('TEXT_FILTER_BY_USERS','Filter by users');
define('TEXT_FILTER_BY_VALUES','Filter by values');
define('TEXT_DATE_FROM','From');
define('TEXT_DATE_TO','To');
define('TEXT_DESCENDING_ORDER','Descending Order');
define('TEXT_ASCENDING_ORDER','Ascending Order');
define('TEXT_LISTING_FILTERS_CFG_INFO','Set filters that will be used by default for items listing');
define('TEXT_SELECT_ENTITY','Select Entity');
define('TEXT_FIELDTYPE_ENTITY_SELECT_ENTITY_TOOLTIP','Items from this entity will be used as values for this field');
define('TEXT_DETAILS','Details');
define('TEXT_LANGUAGE','Language');
define('TEXT_SKIN','Skin');
define('TEXT_SKIN_TOOLTIP','By default, if the skin is not set, users can change the skin.<br>Selected skin will be installed for all users, and change the skin will be hidden.');
define('TEXT_COMMENT','Comment');
define('TEXT_PREVIOUS_COMMENTS','Previous Comments');
define('TEXT_PAGE_NOT_FOUND_HEADING','Page not found!');
define('TEXT_PAGE_NOT_FOUND_CONTENT','The page you are opening for does not exist.');
define('TEXT_TOP_ENTITIES','Top Entities');
define('TEXT_SUB_ENTITIES','Sub Entities');
define('TEXT_FILTER_FIELD_VALUES_NOT_AVAILABLE','The values ​​of this field are not available in the report.');
define('TEXT_NEW_PROJECT_VERSION','New Version!');
define('TEXT_NEW_PROJECT_VERSION_INFO','Rukovoditel %s is available! Please update now.');
define('TEXT_REMOVE_INSTALL_FOLDER','Please remove "install" folder');
define('TEXT_WITH_SELECTED','With Selected');
define('TEXT_EXPORT','Export');
define('TEXT_HEADING_EXPORT','Export');
define('TEXT_BUTTON_EXPORT','Export');
define('TEXT_SELECT_FIELD_TO_EXPORT','Select fields to export.');
define('TEXT_FILENAME','Filename');
define('TEXT_PLEASE_SELECT_ITEMS','Please select items');
define('TEXT_INTERNAL_FIELDS','Internal fields');
define('TEXT_RELATIONSHIP_HEADING','Relationship');
define('TEXT_URL_HEADING','Url');
define('TEXT_MORE_ACTIONS','More Actions');
define('TEXT_EXPORT_COMMENTS','Export comments');
define('TEXT_HEADING_IMPORT_DATA','Import Spreadsheet');
define('TEXT_HEADING_IMPORT_DATA_TO','Import Spreadsheet to: %s');
define('TEXT_IMPORT_DATA_INFO','You can import data from spreadsheet in Exel format.');
define('TEXT_PARENT_ITEM_ID','Parent Item ID');
define('TEXT_PARENT_ITEM_ID_INFO','Enter parent item ID form entity: %s');
define('TEXT_PARENT_ITEM_ID_NOT_FOUND','Item #%s not found in entity %s. Please enter correct item ID.');
define('TEXT_FILE_NOT_LOADED','File is not loaded.');
define('TEXT_IMPORT_BIND_FIELDS','Bind fields with spreadsheet columns below and start import. Column without binded field will not be imported.');
define('TEXT_BIND_FIELD','Bind Field');
define('TEXT_HEADING_BIND_FIELD','Bind Field');
define('TEXT_NONE','None');
define('TEXT_IMPORT_FIRST_ROW','Import first row?');
define('TEXT_DATEPICKER_DAYS','"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"');
define('TEXT_DATEPICKER_DAYSSHORT','"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"');
define('TEXT_DATEPICKER_DAYSMIN','"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa", "Su"');
define('TEXT_DATEPICKER_MONTHS','"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"');
define('TEXT_DATEPICKER_MONTHSSHORT','"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"');
define('TEXT_DATEPICKER_TODAY','Today');
define('TEXT_USE_SEARCH','Use Search');
define('TEXT_USE_SEARCH_INFO','Display instant results as you type');
define('TEXT_SELECT_SOME_VALUES','Select some options');
define('TEXT_NO_RESULTS_MATCH','No results match');
define('TEXT_USER_PWD_CHANGED_EMAIL_SUBJECT','Your password has been changed');
define('TEXT_USER_PWD_CHANGED_EMAIL_BODY','Your password has been changed by the administrator');
define('TEXT_DATE_BACKGROUND','Background Color');
define('TEXT_DATE_BACKGROUND_TOOLTIP','Past due date will be highlighted in the selected color.');
define('TEXT_USE_EDITOR_IN_COMMENTS','Use HTML editor');
define('TEXT_USE_EDITOR_IN_COMMENTS_TOOLTIP','Use HTML editor for comments');
define('TEXT_HEADING_CECK_VERSION','Check Version');
define('TEXT_VERSION_INFO','You are using Rukkovoditel');
define('TEXT_UPDATES_INSTALLED','Updates successfully installed');
define('TEXT_USER_PUBLIC_PROFILE_CFG_INFO','Public profile is displayed when you hover over the name of the user. By default, displays users photo.<br>Just move fields between the boxes to include or exclude fields in profile.');
define('TEXT_FIELDS_IN_USER_PUBLIC_PROFILE','Fields in profile');
define('TEXT_FIELDS_EXCLUDED_FROM_USER_PUBLIC_PROFILE','Excluded from the profile');
define('TEXT_USER_PUBLIC_PROFILE_NO_FIELDS','There is no available fields to display in the public profile.');
define('TEXT_HEADING_EXTENSION','Extension');
define('TEXT_EXTENSION_IFNO','Extension will extend your application by adding features such as Gantt charts, calendar, graphical reports and more.');
define('TEXT_PERIOD','Period');
define('TEXT_DAILY','Daily');
define('TEXT_MONTHLY','Monthly');
define('TEXT_YEARLY','Yearly');
define('TEXT_FIRST_DAY_OF_WEEK','First Day Of Week');
define('TEXT_FIRST_DAY_OF_WEEK_INFO','Will be displayed as the first day of week in calendar');
define('TEXT_SETTINGS','Settings');
define('TEXT_FULL_ACCESS','Full Access');
define('TEXT_MORE_INFO','More Info');
define('TEXT_SETP','Step');
define('TEXT_SAVING','Saving...');
define('TEXT_UNDO','Undo');
define('TEXT_REDO','Redo');
define('TEXT_INSERT','Insert');
define('TEXT_MOVE_UP','Move Up');
define('TEXT_MOVE_DOWN','Move Down');
define('TEXT_ZOOM_OUT','Zoom Out');
define('TEXT_ZOOM_IN','Zoom In');
define('TEXT_PRINT','Print');
define('TEXT_MENU_DONATE','Donate');
define('TEXT_ERROR_NO_HEADING_FIELD','There is no field set as Heading. Please set some field as Heading on Fields Configuration page.');
define('TEXT_ERROR_LOADING_DATA','Error loading data');
define('TEXT_CONFIGURE_DASHBOARD','Configure Dashboard');
define('TEXT_CONFIGURE_DASHBOARD_INFO','Just move reports between the boxes to include or exclude reports on the dashboard.');
define('TEXT_REPORTS_ON_DASHBOARD','Dashboard');
define('TEXT_MY_REPORTS','My Reports');
define('TEXT_CONFIGURE_THEME','Configure Theme');
define('TEXT_SIDEBAR','Sidebar');
define('TEXT_SIDEBAR_POSITION','Sidebar Position');
define('TEXT_SCALE','Scale');
define('TEXT_DEFAULT','Default');
define('TEXT_SIDEBAR_FIXED','Fixed');
define('TEXT_SIDEBAR_POS_LEFT','Left');
define('TEXT_SIDEBAR_POS_RIGHT','Right');
define('TEXT_SCALE_REDUCED','Reduced');

//new defines for version 1.5
define('TEXT_FIELDTYPE_RELATED_RECORDS_TITLE','Related Items');
define('TEXT_FIELDTYPE_RELATED_RECORDS_TOOLTIP','Special field allows you to link Items between entities');
define('TEXT_FIELDTYPE_RELATED_RECORDS_SELECT_ENTITY_TOOLTIP','Items from selected Entity can be related to items from');
define('TEXT_BUTTON_ADD','Add');
define('TEXT_BUTTON_LINK','Link');
define('TEXT_BUTTON_DELETE_RELATION','Delete Relation');
define('TEXT_LINK_RECORD','Link Record');
define('TEXT_SEARCH_RECORD_BY_ID','Search records by ID');
define('TEXT_ENTITY','Entity');
define('TEXT_FILTERS_DISPLAY','Show');
define('TEXT_FILTERS_DISPLAY_WITH_RELATED_RECORDS','Show related records');
define('TEXT_FILTERS_DISPLAY_WITHOUT_RELATED_RECORDS','Show without related records');
define('TEXT_FILTERS_FOR_ENTITY','Filters for Entity');
define('TEXT_FILTERS_FOR_ENTITY_SHORT','For Entity');
define('TEXT_REPORT','Report');
define('TEXT_ADD_IN','Add in');
define('TEXT_SELECT_AN_OPTION','Select an Option');
define('TEXT_SELECT_SOME_OPTIONS','Select Some Options');
define('TEXT_DISPLAY_IN_MENU','Display in Menu');
define('TEXT_MENU_ICON_TITLE','Menu Icon');
define('TEXT_MENU_ICON_TITLE_TOOLTIP','Enter icon name from  <a href="https://fontawesome.com/v4.7.0/icons/" target="_blank">Font Awesome</a> or <a href="https://icons8.com/line-awesome" target="_blank">Line Awesome</a> lib.<br>For example: fa-bell or la-bell.');

//new defines for version 1.6
define('TEXT_FIELDTYPE_INPUT_MASKED','Input Masked Filed');
define('TEXT_FIELDTYPE_INPUT_MASKED_TOOLTIP','To enter the data in a certain format (dates,phone numbers, etc)');
define('TEXT_INPUT_FIELD_MASK','Mask');
define('TEXT_INPUT_FIELD_MASK_TIP','For example: 99/99/9999 or (999) 999-9999 or a*-999-a999<br>
<ul>
  <li>a - Represents an alpha character (A-Z,a-z)</li>
  <li>9 - Represents a numeric character (0-9)</li>
  <li>* - Represents an alphanumeric character (A-Z,a-z,0-9)</li>
</ul>');
define('TEXT_MENU_REVIEWS','Reviews');
define('TEXT_AVAILABLE_FIELDS','Available Fields');
define('TEXT_NO_NUMERIC_FIELDS','There are no numeric fields which you can use.');
define('TEXT_EXTENSION_LICENSE_KEY_IFNO','When buying Extension you need to enter the domain name <span class="label label-sm label-warning">%s</span> to get a product key.');
define('TEXT_URL_PREFIX','Prefix');
define('TEXT_URL_PREFIX_TIP','If url don\'t have prefix then prefix "http: //" will be automatically added to the link. If you want to use a different prefix by default (such as "sip:"), enter it in this field.');
define('TEXT_URL_PREVIEW_TEXT','Link view');
define('TEXT_URL_PREVIEW_TEXT_TIP','Text "View" using by default in link. You can enter own text or enter "none" to show field value in link.');
define('TEXT_SEARCH_HELP','Search Help');
define('TEXT_SEARCH_HELP_INFO_FIELDS','You can specify which fields will be searched');
define('TEXT_SEARCH_HELP_INFO_FIELDS_EXAMPLE','If the fields are not specified, the search is performed on all available fields, which allowed the search.');
define('TEXT_SEARCH_HELP_INFO_ANDOR','Keywords may be separated by AND and/or OR statements for greater control of the search results.');
define('TEXT_SEARCH_HELP_INFO_ANDOR_EXAMPLE','For example, <u>Task1 AND Task2</u> would generate a result set that contain both words. However, for <u>Task1 OR Task2</u>, the result set returned would contain both or either words.');
define('TEXT_SEARCH_HELP_INFO_QUOTES','Exact matches can be searched for by enclosing keywords in double-quotes.');
define('TEXT_SEARCH_HELP_INFO_QUOTES_EXAMPLE','For example, <u>"My Task"</u> would generate a result set which match the exact string.');
define('TEXT_SEARCH_HELP_INFO_BRACKETS','Brackets can be used for further control on the result set.');
define('TEXT_SEARCH_HELP_INFO_BRACKETS_EXAMPLE','For example, <u>Microsoft and (keyboard or mouse or "visual basic")');
define('TEXT_ERROR_INVALID_KEYWORDS','Invalid keywords.');
define('TEXT_SEARCH_IN_COMMENTS','Search in comments');
define('TEXT_GO_TO','Go to');
define('TEXT_FIELDTYPE_IMAGE_TITLE','Image');
define('TEXT_FIELDTYPE_IMAGE_TOOLTIP','Allows upload single image.');
define('TEXT_PREVIEW_IMAGE_SIZE','Preview width');
define('TEXT_PREVIEW_IMAGE_SIZE_TIP','The maximum width of the image when displaying (Default 250px');
define('TEXT_USE_IMAGE_PREVIEW','Use preview');
define('TEXT_USE_IMAGE_PREVIEW_TIP','Use preview for images');
define('TEXT_NOTIFY_WHEN_CHANGED','Notify when changed');
define('TEXT_NOTIFY_WHEN_CHANGED_TIP','Assigned users will be notified when value changed.');
define('TEXT_DEFAULT_EMAIL_SUBJECT_UPDATED_ITEM','Item updated:');
define('TEXT_EMAIL_SUBJECT_UPDATED_ITEM','Email Subject for updated item');
define('TEXT_EMAIL_SUBJECT_UPDATED_ITEM_TOOLTIP','This Subject will be used when you update a new item');
define('TEXT_ENTER_VALUE','Enter value');
define('TEXT_ENTER_CORRECT_VALUE','Enter correct value');
define('TEXT_DAYS_BEFORE_DATE','Days before a specified date');
define('TEXT_DAYS_BEFORE_DATE_TIP','Enter a few days and background color to highlight the field before a specified date.');
define('TEXT_FIELD_SETTINGS','Field Settings');
define('TEXT_FIELDS_IN_POPUP','Fields in popup');
define('TEXT_FIELDS_IN_LISTING_RELATED_ITEMS','Select the fields that will be displayed in the list of related records. Since the width of the list is limited to use only the Key fields. Other fields may be necessary can be displayed in a popup window.');
define('TEXT_FIELDS_IN_POPUP_RELATED_ITEMS','Select the fields that will be displayed in a popup window when you hover on the related record.');
define('TEXT_CONDITION_EMPTY_VALUE','Empty Value');
define('TEXT_DISPLAY_USER_NAME_ORDER','Displays the name of the user');
define('TEXT_FIRSTNAME_LASTNAME','First Name - Last Name');
define('TEXT_LASTNAME_FIRSTNAME','Last Name - First Name');
define('TEXT_FILTER_BY_MONTH','Filter by Month');
define('TEXT_FILTER_BY_YEAR','Filter by Year');
define('TEXT_FILTER_BY_OVERDUE_DATE','Overdue dates only');
define('TEXT_FILTER_BY_MONTH_TOOLTIP','Available values: "0" - the current month, "-1" - the previous month, "+1" - next month. You can also specify multiple values: "-1&2&3"');
define('TEXT_FILTER_BY_YEAR_TOOLTIP','Available values: "0" - this year, "-1" - the previous year, "1" - next year. You can also specify multiple values: "-1&2&3"');
define('TEXT_RESERVED_FORM_TAB','Reserved form tab. You can change the Name but you can\'t delete it.');
define('TEXT_FIELDTYPE_RELATED_RECORDS_TOOLTIP_EXTRA','
  <span class="help-block">
    <span class="label label-sm label-info">Note:</span>
    this field is not displayed in the form of the creation of the record. Add related items possible after the record was created.
  </span>');

//new defines for version 1.7
define('TEXT_ASSIGNED_TO','Assigned To');
define('TEXT_DISPLAY_IN_HEADER','In Header');
define('TEXT_DISPLAY_IN_HEADER_TOOLTIP','Report icon will be displayed in top navigation menu.');
define('TEXT_LISTING_HORISONTAL_SCROLL','Listing Horizontal Scrolling');
define('TEXT_LISTING_HORISONTAL_SCROLL_INFO','By default, horizontal scrolling is applied to all fields in the list. You can fix a few fields from the left side.');
define('TEXT_NUMBER_FIXED_FIELD','Number of fixed fields');
define('TEXT_NUMBER_FIXED_FIELD_INFO','Enter the number of fixed fields which horizontal scrolling will not be applied.');
define('TEXT_DISPLAY_IN_MAIN_COLUMN','Display in the main column');
define('TEXT_DISPLAY_IN_MAIN_COLUMN_INFO','By default, Related Records are displayed in the right column. By setting this option, the Related Records will be displayed as a separate list on the record Info Page.');
define('TEXT_SEARCH_RECORD_BY_ID_NAME_TIP','Search records by ID or Name. Leave blank to display all records.');
define('TEXT_DISPLAY_NAME_AS_LINK','Display Name as link');
define('TEXT_DISPLAY_NAME_AS_LINK_INFO','Item Name will refer to the Item page');
define('TEXT_UNLINK','Unlink');
define('TEXT_SELECT_ALL','Select All');
define('TEXT_CALCULATE_TOTALS','Сalculate totals in listing');
define('TEXT_CALCULATE_TOTALS_INFO','The sum of the values of this field will be counted in the items listing');
define('TEXT_DISPLAY_COMMENTS_ID','Display comment ID');
define('TEXT_DISPLAY_COMMENTS_TOOLTIP','By number, you can easily refer to the comment');
define('TEXT_ERROR_COMMENTS_FORM_GENERAL','None of the fields are not filled');
define('TEXT_SELECT_HEADING_FIELD','Select field that will be display as Heading in Listing');
define('TEXT_ERROR_IMAGE_FILE_IS_NOT_UPLOADED','File is not uploaded. The maximum file size %s Mb.');
define('TEXT_FIELDTYPE_PARENT_ITEM_ID_TITLE','Parent');
define('TEXT_APPLIED_FILTERS','Applied Filters');
define('TEXT_NO_FILTERS_SETUP','No filters');
define('TEXT_DEFAULT_FILTERS','Default Filters');
define('TEXT_SAVE_FILTERS','Save Filters');
define('TEXT_UPDATE','Update');
define('TEXT_DELETE_FILTERS','Delete Filters');
define('TEXT_MESSAGE_FILTER_SAVED','Filter Saved');
define('TEXT_COPYRIGHT_NAME','Copyright Text');
define('TEXT_COPYRIGHT_NAME_TOOLTIP','Enter your Company Name here. The text displays at the bottom of the page. Symbol &copy; added automatically.');
define('TEXT_POWERED_BY','Powered by');
define('TEXT_POWERED_BY_TITLE','Universal Project Management Software');
define('TEXT_MENU_GLOBAL_LISTS','Global Lists');
define('TEXT_HEADING_GLOBAL_LISTS','Global Lists');
define('TEXT_GLOBAL_LISTS_INFO','Global lists can be applied in all entities for field types: "Drop-down list", "Checkboxes", "Radioboxes".');
define('TEXT_HEADING_GLOBAL_LIST_IFNO','Global List');
define('TEXT_GLOBAL_LIST_CHOICES_CONFIG','List Choices');
define('TEXT_BUTTON_SORT','Sort');
define('TEXT_SORT_VALUES','Sort Values');
define('TEXT_USE_GLOBAL_LIST','Use Global List');
define('TEXT_USE_GLOBAL_LIST_TOOLTIP','The values of the selected list will be used for this field');
define('TEXT_BUTTON_CANCEL','Cancel');
define('TEXT_NUMBER_FORMAT','Number Format');
define('TEXT_NUMBER_FORMAT_INFO','Enter: number of decimal points (0-9) / decimal separator / thousands separator. Valid values for the separator: dot, comma, space, or symbol * it means the separator is not applicable.<br>Leave field empty to don\'t use number format');
define('TEXT_NUMBER_FORMAT_INFO_NOTE','Note: This format is used by default when you create a new numeric field only. To display number the numeric field uses individual settings.');
define('TEXT_BUTTON_SEND_TEST_EMAIL','Send Test Email');
define('TEXT_EMAIL_USE_SMTP_INFO','Before turn on SMTP you can send test email.<br>Email with subject "%s" will be sent to: %s');
define('TEXT_TEST_EMAIL_SUBJECT','This is the test email');
define('TEXT_EMAIL_SENT','Email successfully sent');
define('TEXT_DEFAULT_TEXT','Default Text');
define('TEXT_DEFAULT_TEXT_INFO','Can be empty or enter "Please Select" for example');
define('TEXT_DEFAULT_DATE','Default Date');
define('TEXT_DEFAULT_DATE_INFO','Leave blank or enter a number. For example: 0 - the current date, 5 - current date + 5 days.');
define('TEXT_FIELDTYPE_BOOLEAN_TITLE','Boolean Field ');
define('TEXT_FIELDTYPE_BOOLEAN_TOOLTIP','Only two values can be stored in a logical field, "Yes" and "No"');
define('TEXT_BOOLEAN_TRUE','Yes');
define('TEXT_BOOLEAN_FALSE','No');
define('TEXT_BOOLEAN_TRUE_VALUE','Value "Yes"');
define('TEXT_BOOLEAN_TRUE_VALUE_INFO','Leave blank or enter your value');
define('TEXT_BOOLEAN_FALSE_VALUE','Value "No"');
define('TEXT_BOOLEAN_FALSE_VALUE_INFO','Leave blank or enter your value');
define('TEXT_FIELDTYPE_TEXT_PATTERN','Text Pattern');
define('TEXT_FIELDTYPE_TEXT_PATTERN_TOOLTIP','Special field that allows you to display text in a specified pattern.');
define('TEXT_PATTERN','Pattern');
define('TEXT_ENTER_TEXT_PATTERN_INFO','Use [Field ID] to set the value of the field in the template.<br>Example: "[36] your text [54]" where the 36 and 54 - fields ID.<br>Also available: [id], [date_added], [created_by], [parent_item_id], [current_user_name]');
define('TEXT_FIELDTYPE_USER_STATUS_TOOLTIP','Inactive users can\'t login and don\'t receive email notification');
define('TEXT_APP_LOGO_URL','Logo Link');
define('TEXT_APP_LOGO_URL_TOOLTIP','Will open in a new window');
define('TEXT_USERS_CONFIGURATION','Users Settings');
define('TEXT_ALLOW_CHANGE_USERNAME','Allow change the Username');
define('TEXT_ALLOW_REGISTRATION_WITH_THE_SAME_EMAIL','Allow registration with the same email');
define('TEXT_FIELDS_TYPES_GROUP_INPUT_FIELDS','Input Field');
define('TEXT_FIELDS_TYPES_GROUP_DATES','Date');
define('TEXT_FIELDS_TYPES_GROUP_UPLOAD','Upload');
define('TEXT_FIELDS_TYPES_GROUP_TEXT','Text');
define('TEXT_FIELDS_TYPES_GROUP_LIST','List');
define('TEXT_FIELDS_TYPES_GROUP_USERS','Users');
define('TEXT_FIELDS_TYPES_GROUP_ENTITY','Entity');
define('TEXT_DOWNLOAD_ALL_ATTACHMENTS','Download All');
define('TEXT_FILTER_BY_WEEK','Filter by Week');
define('TEXT_FILTER_BY_WEEK_TOOLTIP','Available values: "0" - the current week, "-1" - the previous week, "+1" - next week. You can also specify multiple values: "-1&2&3"');
define('TEXT_HIDE_FIELD_NAME','Hide Field Name');
define('TEXT_HIDE_FIELD_NAME_TIP','In order to save space when displaying a list of users you can hide the Field Name.');
define('TEXT_LAST_COMMENT_DATE','Last Comment Date');
define('TEXT_HIDE_FIELD_IF_EMPTY','Hide field if value is empty');
define('TEXT_HIDE_FIELD_IF_EMPTY_TIP','On Item Info page the field will be hidden if the field value is empty');
define('TEXT_TOOLTIP_DISPLAY_AS_ICON','Display as Icon');
define('TEXT_TOOLTIP_DISPLAY_AS_ICON_INFO','By default, the tooltip text is displayed under the field');
define('TEXT_MENU_DATABASE_EXPORT','Export Database');
define('TEXT_DATABASE_EXPORT_APPLICATION','Export Database (Application Template)');
define('TEXT_BUTTON_EXPORT_DATABASE','Export Database');
define('TEXT_DATABASE_EXPORT_EXPLANATION','This function creates a template of your Application.<br>Export only the data relevant to the settings of your application.<br>Using the template you can clone your app or share.');
define('TEXT_DATABASE_EXPORT_TOOLTIP','<b>Note:</b> export only the current user and his Login/Password which you can use to login to the system after installation of the template.<br>To install the template use button "Restore DB from file" .');
define('TEXT_COPY_FIELDS','Copy Fields');
define('TEXT_COPY','Copy');
define('TEXT_PLEASE_SELECT_FIELDS','Please select fields');
define('TEXT_SELECT_FORM_TAB','Select From Tab');
define('TEXT_FIELDS_COPY_SUCCESS','Fields are successfully copied');
define('TEXT_HEADING_TEMPLATE','Heading Template');
define('TEXT_HEADING_TEMPLATE_INFO','By default using Heading Field');
define('TEXT_IS_UNIQUE_FIELD_VALUE','Unique Field');
define('TEXT_IS_UNIQUE_FIELD_VALUE_TIP','Entered value will be checked for uniqueness for that entity');
define('TEXT_PLEASE_WAIT_UNIQUE_FIELDS_CHECKING','Validates the data. Will try again after a few seconds.');
define('TEXT_UNIQUE_FIELD_VALUE_ERROR','The field value must be unique');
define('TEXT_UNIQUE_FIELD_VALUE_ERROR_GENERAL','Some fields must be unique. They are marked above.');
define('TEXT_IMPORT_DATA_TOOLTIP','Before start import, you must prepare the data in Excel
<ul>
  <li>date format: YY-MM-DD</li>	
  <li>format date and time: YY-MM-DD HH:MM</li>
  <li>numbers format: 20000.00 (number of decimal points - any, separator for the decimal point - dot, thousands separator - none)</li>
  <li>boolean field: true | false</li>
</ul>  
Duplicate fields that require prepare, and using formulas in Excel, prepare the data. Need to resave the data as values, otherwise, the formulae are imported.');

//new defines for version 1.8
define('TEXT_WARN_DELETE_ENTITY_HAS_RELATIONSHIP','You can\'t delete entity <b>%s</b> because it has relationship with: <br>%s.<br><br>Delete all fields which related to this entity.');
define('TEXT_SEARCH_IN_ALL','Disable filters');
define('TEXT_SEARCH_TYPE_AND','Search all words');
define('TEXT_SEARCH_TYPE_MATCH','Exact match');
define('TEXT_SEARCH_HELP_INFO_CONFIGURATION','Search Settings');
define('TEXT_SEARCH_HELP_INFO_CONFIGURATION_DESCRIPTION','
			<ul>
				<li>Disable filters<br>This option expands the search area by disabling filters.</li>
				<li>Search all words<br>Will show records that contain all words.</li>
				<li>Exact match<br>Will show records that contain the exact match keywords.</li>
			</ul>');
define('TEXT_IS_ACTIVE_FILTER','Active Filter?');
define('TEXT_IS_ACTIVE_FILTER_INFO','Inactive filters are displayed in the list of installed filters, but are not used when fetching data');
define('TEXT_SAVE_AS_TEMPLATE','Save as template');
define('TEXT_SAVE_AS_TEMPLATE_INFO','The selected values can be saved as a template. The templates are available in the list of installed filters.');
define('TEXT_MY_TEMPLATES','My Templates');
define('TEXT_ENTER_TEMPLATE_NAME','Enter template name');
define('TEXT_SAVE_TAMPLATE_NOTE','Selected fields will be saved in the new template');
define('TEXT_TEMPLATES_FIELDS','Fields');
define('TEXT_TEMPLATE_ALREADY_EXIST','Template "%s" already exists');
define('TEXT_TEMPLATES_UPDATE_FIELDS','Update the selected fields for this template');
define('TEXT_SELECT_TEMPLATE','Select Template');
define('TEXT_ADD_NEW_TEMPLATE','New Template');
define('TEXT_BUTTON_UPDATE','Update');
define('TEXT_UPDATE_SELECTED_TEMPLATE_INFO','Selected fields will be updated for the this template');
define('TEXT_MENU_CONFIGURATION_MENU','Menu Configuration');
define('TEXT_CONFIGURATION_MENU_EXPLAIN','You can configure additional sections on the main menu.');
define('TEXT_ADD_NEW_MENU_ITEM','Add menu section');
define('TEXT_SORT','Sort');
define('TEXT_SELECT_ENTITIES','Select entities');
define('TEXT_FIELDTYPE_INPUT_VPIC_TITLE','vPIC');
define('TEXT_FIELDTYPE_INPUT_VPIC_TOOLTIP','Input field with "Decode" button allows Decode a Vehicle Identification Number (VIN) for regulated vehicle types using service <a href="https://vpic.nhtsa.dot.gov/" target="_blank">vpic.nhtsa.dot.gov</a>');
define('TEXT_FIELDS_TYPES_GROUP_SPCEIAL_FIELDS','Special');
define('TEXT_DECODE_VIN','Decode a Vehicle Identification Number');
define('TEXT_VPIC_AUTO_FILL_FIELDS','Auto fill fields');
define('TEXT_VPIC_AUTO_FILL_FIELDS_TIP','The data will be automatically filled if the field name and the name of the specifications are the same');
define('TEXT_VPIC_OTHER_DETAILS','Vehicle Details');
define('TEXT_VPIC_OTHER_DETAILS_TIP','By default decode next details: Make, Manufacturer Name, Model, Model Year, Vehicle Type, Body Class.<br>If you need more then enter Names by comma.<br><b>Note:</b> click "Show All Vehicle Details" on Decoder page to get correct Element Name from vpic.nhtsa.dot.gov');
define('TEXT_DATA_SAVED','Data saved');
define('TEXT_SELECT_NONOE','Deselect');
define('TEXT_DELETE_SELECTED_CONFIRMATION','Are you sure you want to delete the selected records?');
define('TEXT_QUICK_COMMENT','Quick comment');
define('TEXT_COMMENT_PLACEHOLDER','Enter you comment here');
define('TEXT_REPLY','Reply');
define('TEXT_USERS_IMPORT_NOTE','When you import users, the following fields are mandatory: First name, Last Name, E-mail. If the Username is not specified, it uses the Username from E-mail<br>
<b>Please note:</b> that when you import users, notification of the new account not sent. Due to the fact that the web servers have limitations on the number of mail sending at once.<br>
Imported user must use the Restore Password form to retrieve his password.');
define('TEXT_USERS_IMPORT_USERS_GROUP','Select Access Group fro Users');
define('TEXT_IMPORT_BIND_FIELDS_ERROR','Import error: do not select the fields associated with the columns of the table');
define('TEXT_IMPORT_BIND_USERS_FIELDS_ERROR','Import error: next fields are mandatory: First name, Last Name, E-mail');
define('TEXT_IMPORT_SET_PWD_AS_USERNAME','Use Username as the password');
define('TEXT_USERS_IMPORT_ERROR','The following users were not imported because already exist:');
define('TEXT_SIZE','Size');
define('TEXT_BACKUP_TYPE_AUTO','Autobackup');
define('TEXT_BACKUP_FOLDER','Backup Folder');
define('TEXT_BACKUP_DESCRIPTION_TIP','Enter a comment to the backup of the database or leave the field blank');
define('TEXT_BUTTON_DB_RESOTRE_FROM_FILE','Restore DB from file');
define('TEXT_FILE','File');
define('TEXT_MAX_FILE_SIZE','The maximum file size %s Mb.');
define('TEXT_CRON_BACKUP','<a href="https://docs.rukovoditel.net/index.php?p=70" target="_blank"><u>Cron</u></a> backup');
define('TEXT_MENU_MAINTENANCE_MODE','Maintenance Mode');
define('TEXT_HEADING_MAINTENANCE_MODE','Maintenance Mode Configuration');
define('TEXT_MAINTENANCE_MODE','Maintenance Mode');
define('TEXT_MAINTENANCE_MODE_NOTE','If maintenance mode is enabled, only administrators can log on to the system.<br>Other users that were logged in, will automatically logoff.<br>On the login page is a message that you can configure below.');
define('TEXT_MESSAGE_HEADING','Message Heading');
define('TEXT_MESSAGE_CONTENT','Message Content');
define('TEXT_MAINTENANCE_MESSAGE_HEADING','Maintenance Mode!');
define('TEXT_MAINTENANCE_MESSAGE_CONTENT','Only administrators can log on to the system');
define('TEXT_FORMULA_TIP_USAGE','You can use MySql syntax in formula: conditional operator "if([344]>10,[321],0)", a mathematical function "ABS([23])" and internal fields "id, date_added, create_by"');
define('TEXT_MENU_ATTACHMENTS','Attachments');
define('TEXT_HEADING_ATTACHMENTS_CONFIGURAITON','Attachments Configuration');
define('TEXT_MAX_UPLOAD_FILE_SIZE','Max upload file size');
define('TEXT_MAX_UPLOAD_FILE_SIZE_TIP','<a href="https://docs.rukovoditel.net/index.php?p=10" target="_blank">' . 'How to change this value?' . '</a>');
define('TEXT_RESIZE_IMAGES','Resize images');
define('TEXT_RESIZE_IMAGES_TIP','To save space on the web-server, you can reduce the loaded image.<br>If enabled, the loaded image will be scaled according to width or height specified below.');
define('TEXT_MAX_IMAGE_WIDTH','Maximum image width');
define('TEXT_MAX_IMAGE_HEIGHT','Maximum image height');
define('TEXT_ENTER_VALUES_IN_PIXELS_OR_LEAVE_LBANK','Enter the size in pixels or leave the field blank.');
define('TEXT_IMAGES_TYPES','Images type');
define('TEXT_RESIZE_IMAGES_TYPES_TIP','Specify the types of images which will be used for scaling');
define('TEXT_SKIP_IMAGE_RESIZE','Do not apply scaling to images');
define('TEXT_SKIP_IMAGE_RESIZE_TIP','Enter the size in pixels or leave the field blank.<br>If the width or height of the image exceeds the size specified, no scaling will be applied.');
define('TEXT_RECAPTCHA_VERIFY_ROBOT','Please confirm that you are not a robot!');
define('TEXT_MENU_SECURITY','Security');
define('TEXT_HEADING_SECURITY_CONFIGURATION','Security Settings');
define('TEXT_STATUS','Status');
define('TEXT_RECAPTCHA_SITE_KEY','Site Key');
define('TEXT_RECAPTCHA_SECRET_KEY','Secret Key');
define('TEXT_RECAPTCHA_INFO','reCAPTCHA will be displayed on the login page. <a href="https://www.google.com/recaptcha/intro/index.html" target="_blank">Read more about reCAPTCHA</a>');
define('TEXT_RECAPTCHA_HOW_ENABLE','To enable, open the file "config/security.php" change CFG_RECAPTCHA_ENABLE to "true", enter key in CFG_RECAPTCHA_KEY and secret key in CFG_RECAPTCHA_SECRET_KEY.');
define('TEXT_RESTRICTED_COUNTRIES','Restriction by Country');
define('TEXT_ALLOWED_COUNTRIES','Allowed countries');
define('TEXT_RESTRICTED_COUNTRIES_INFO','On the login page, users will be validated  with a list of allowed countries. The user\'s country is determined by IP. If the country is not in the allowed list or is not determined, the login page will be unavailable.');
define('TEXT_RESTRICTED_COUNTRIES_HOW_ENABLE','To enable, open the file "config/security.php" change CFG_RESTRICTED_COUNTRIES_ENABLE to "true" and enter the list of allowed countries separated by a comma in CFG_ALLOWED_COUNTRIES_LIST, for example "EN,US"');
define('TEXT_RESTRICTED_BY_IP','Restriction by IP');
define('TEXT_RESTRICTED_BY_IP_INFO','On the login page, users will be validated  with a list of allowed IP. If the IP is not in the allowed list or is not determined, the login page will be unavailable.');
define('TEXT_RESTRICTED_BY_IP_HOW_ENABLE','To enable, open the file "config/security.php" change CFG_RESTRICTED_BY_IP_ENABLE to "true" and enter the allowed IP list separated by a comma in CFG_ALLOWED_IP_LIST, such as "192.168.2.1,192.168.2.2"');
define('TEXT_ALLOWED_IP','Allowed IP');
define('TEXT_DISPLAY_COUNTER_ON_DASHBOARD','Display as counter on dashboard');
define('TEXT_STATISTICS','Statistics');
define('TEXT_COUNTERS','Counters');
define('TEXT_NOTIFICATIONS_SCHEDULE','Notifications on schedule');
define('TEXT_NOTIFICATIONS_SCHEDULE_TIP','Befor enable this feature you have to configure CRON_HTTP_SERVER_HOST in config/server.php and run the file every hour (<a href="https://docs.rukovoditel.net/index.php?p=70" target="_blank"><u>Cron</u></a>):');
define('TEXT_NOTIFICATIONS_SCHEDULE_INFO','Users can set notifications on schedule for Standart Reports');
define('TEXT_DAY','Day');
define('TEXT_TIME','Time');
define('TEXT_NOTIFICATION','Notification');
define('TEXT_REPORTS_NOTIFICATION_EMAIL','Hello.<p>You are receiving this notification because you are watching the report "%s".</p>');
define('TEXT_TECHNICAL_SUPPORT','Technical Support Department');
define('TEXT_TECHNICAL_SUPPORT_INFO','Internal notifications, such as password recovery and other will be sent from the technical support email');
define('TEXT_DISABLE_NOTIFICATIONS','Disable notifications');
define('TEXT_DISABLE_NOTIFICATIONS_INFO','You will not receive email notifications for records where you are assigned');
define('TEXT_HEADER_TOP_MENU','Header Menu');
define('TEXT_CONFIGURE_HOT_REPORTS_INFO','Just move reports between the boxes to include or exclude reports in header');
define('TEXT_URL','Url');
define('TEXT_DEFAULT_VALUE','Default Value');
define('TEXT_DEFAULT_VALUE_INFO','Enter the default value or leave blank');
define('TEXT_DO_NOT_NOTIFY','Do not notify');
define('TEXT_DO_NOT_NOTIFY_INFO','The assigned users will not receive notification');
define('TEXT_IS_ACTIVE','Is Active?');
define('TEXT_SEND_ON_SCHEDULE','Send via Cron');
define('TEXT_SEND_EMAILS_ON_SCHEDULE','Send emails on schedule');
define('TEXT_SEND_EMAILS_ON_SCHEDULE_INFO','Before you enable this feature, you must install the scheduled task every minute (<a href="https://docs.rukovoditel.net/index.php?p=70" target="_blank"><u>Cron</u></a>):');
define('TEXT_MAXIMUM_NUMBER_EMAILS','Maximum number of emails');
define('TEXT_MAXIMUM_NUMBER_EMAILS_INFO','The maximum number of emails sent when running Cron');
define('TEXT_SEND_EMAILS_ON_SCHEDULE_DESCRIPTION','Before you enable this feature, check <a href="https://docs.rukovoditel.net/index.php?p=8" target="_blank"><u>restrictions on sending mail</u></a> on your server.');
define('TEXT_MAILER_ERROR','Error sending message to %s');
define('TEXT_HIDE_INSERT_BUTTON_IN_REPORTS','Hide Insert Button in Reports');
define('TEXT_DISABLE_NOTIFICATIONS_FIELDS_INFO','The assigned users will not receive notifications');
define('TEXT_FROM_TO','from %s to %s');

//new defines for version 1.9
define('TEXT_MOVE_LEFT','Move left');
define('TEXT_MOVE_RIGHT','Move right');
define('TEXT_LIMITED_ACCESS','Limited Access');
define('TEXT_SEARCH_USERS','Search users');
define('TEXT_USER_IS_NOT_FOUD','User is not found');
define('TEXT_USERS','Users');
define('TEXT_FIELDTYPE_MAPBBCODE_TITLE','Map');
define('TEXT_FIELDTYPE_MAPBBCODE_TOOLTIP','Input field allows you to enter map coordinates to display the map according to the given coordinates. With the internal map editor, you have the opportunity to allocate the area on a map, draw a line or insert a marker.');
define('TEXT_DEFAULT_POSITION','Default Position');
define('TEXT_DEFAULT_POSITION_TIP','Enter the coordinates on the map. For example: 45.26329,34.10156');
define('TEXT_DEFAULT_ZOOM','Default Zoom');
define('TEXT_DEFAULT_ZOOM_TIP','The scale of the map. For example: 8');
define('TEXT_OPEN_MAP_EDITOR','Open Map Editor ');
define('TEXT_USERS_NOTIFICATIONS','My Notifications');
define('TEXT_DELETE_SELECTED','Delete selected');
define('TEXT_DISABLE_EMAIL_NOTIFICATIONS','Disable email notifications');
define('TEXT_DISABLE_INTERNAL_NOTIFICATIONS','Turn off the internal notification');
define('TEXT_DISABLE_INTERNAL_NOTIFICATIONS_INFO','The top menu "My notifications" will be disabled.');
define('TEXT_DISABLE_HIGHLIGH_UNREAD','Disable the highlighting of unread');
define('TEXT_DISABLE_HIGHLIGH_UNREAD_INFO','Will disable highlighting unread records.');
define('TEXT_FIELDTYPE_BARCODE_TITLE','Barcode');
define('TEXT_FIELDTYPE_BARCODE_TOOLTIP','In the form of a record field value is stored as a number, and in the export template field is displayed in the image is the actual barcode.');
define('TEXT_FIELDTYPE_BARCODE_HEIGHT_TIP','The height of the barcode. Default is 30 pixels.');
define('TEXT_FIELDTYPE_BARCODE_TYPE','Barcode type');
define('TEXT_FIELDTYPE_BARCODE_TYPE_TIP','');
define('TEXT_DISPLAY_FIELD_VALUE','Display field value');
define('TEXT_FIELDTYPE_BARCODE_DSIPLAY_TIP','When you export, by default, displays the barcode only');
define('TEXT_FIELDTYPE_BARCODE_METHOD_GENERATING','Method of generating value');
define('TEXT_FIELDTYPE_BARCODE_METHOD_GENERATING_TIP','Use [Field ID] to set the value of the field in the template.<br>Example: "[36] your text [54]" where the 36 and 54 - input fields ID.<br>[auto:10] the value will be generated automatically. 10 - the length of the value');
define('TEXT_FIELDTYPE_BARCODE_METHOD_GENERATING_TIP_ICON','Enter the generation method or leave the field blank. The value will be automatically generated when you click on the "Save" button');
define('TEXT_INPUT_FIELD_MASK_DEFINITIONS','Mask definitions');
define('TEXT_INPUT_FIELD_MASK_DEFINITIONS_TIP','You can now supply your own mask definitions. Enter each definition in new line, for example:<br>~=[+-]<br>h=[A-Fa-f0-9]');
define('TEXT_INPUT_FIELD_MASK_DEFINITIONS_TIP_ICON','
[abc]	- Any character between the brackets<br>
[^abc] - Any character NOT between the brackets<br>
[0-9] - Any digit between the brackets<br>
(x|y)- Any of the alternatives specified
');
define('TEXT_FIELDTYPE_QRCODE_TITLE','QR Code');
define('TEXT_FIELDTYPE_QRCODE_TOOLTIP','Field to generate a QR code');
define('TEXT_QRCODE_PATTERN','Template for coding');
define('TEXT_HIDE_FIELD_ON_INFO_PAGE','Hide a field on the item page');
define('TEXT_CODE_ERROR_CORRECTION','Code Error Correction (ECC)');
define('TEXT_CODE_ERROR_CORRECTION_L','L - Low');
define('TEXT_CODE_ERROR_CORRECTION_M','M - Middle');
define('TEXT_CODE_ERROR_CORRECTION_Q','Q - Quality');
define('TEXT_CODE_ERROR_CORRECTION_H','H - High');
define('TEXT_PIXEL_SIZE','Pixel size');
define('TEXT_MENU_USERS_REGISTRATION','User registration');
define('TEXT_PUBLIC_REGISTRATION','Public registration');
define('TEXT_USE_PUBLIC_REGISTRATION','Enable public registration');
define('TEXT_PUBLIC_REGISTRATION_USER_GROUP','Select the access group that will be assigned to a new registered user.');
define('TEXT_REGISTRATION_BUTTON_TITLE','Registration button');
define('TEXT_BUTTON_REGISTRATCION','Registration');
define('TEXT_REGISTRATION_NEW_USER','New user registration');
define('TEXT_BUTTON_BACK','Back');
define('TEXT_NOTE','Note');
define('TEXT_ADMINISTRATOR_NOTE','Administrator Note');
define('TEXT_DISABLE_CHANGE_PWD','Disallow password change');
define('TEXT_SELECT_USERS_GROUPS','Choose user groups');
define('TEXT_SEND','Send');
define('TEXT_COLUMN','Column');
define('TEXT_COLUMN_IMPORT_INFO','Specify the column to import');
define('TEXT_SORT_LIKE_FILE','Sort like in file');
define('TEXT_DISABLE_ATTACHMENTS','Disable attachments');
define('TEXT_SHOW','Show');
define('TEXT_APP_LANGUAGE_TIP','Users can change language under My Account page.');
define('TEXT_DISABLE_USERS_DEPENDENCY','Disable dependency');
define('TEXT_DISABLE_USERS_DEPENDENCY_INFO','By default, the list of users depending on the assigned users in the parent record.');
define('TEXT_CALCULATE_AVERAGE_VALUE','Calculate average value');
define('TEXT_REDIRRECTS','Redirects');
define('TEXT_REDIRECT_AFTER_ADDING','Redirect after adding record');
define('TEXT_REDIRECT_AFTER_CLICK_HEADING','Redirect after click on item heading');
define('TEXT_REDIRECT_TO_SUBENTITY','Go to the list of child records (if exist)');
define('TEXT_REDIRECT_TO_LISTING','To stay on the current page');
define('TEXT_REDIRECT_TO_INFO','Go to record info page');
define('TEXT_DISPLAYS_ASSIGNED_ITEMS_ONLY','Displays assigned records only');
define('TEXT_DISPLAYS_ASSIGNED_ITEMS_ONLY_INFO','Adds a filter for the current user');
define('TEXT_ROWS_PER_PAGE_IF_NOT_SET','If not set, it displays all records.');
define('TEXT_CONFIGURE_FILTERS','Configure Filters');

//new defines for version 2.0
define('TEXT_IFRAME','iFrame');
define('TEXT_BUTTON_SEND','Send');
define('TEXT_FIELDTYPE_INPUT_EMAIL_TITLE','Input E-mail Field');
define('TEXT_FIELDTYPE_INPUT_EMAIL_TOOLTIP','Field for entering e-mail addresses');
define('TEXT_ERROR_REQUIRED_EMAIL','Please enter a valid email address.');
define('TEXT_DISPLAY_AS_LINK','Display as a link');
define('TEXT_FIELDTYPE_SECTION','Section');
define('TEXT_FIELDTYPE_SECTION_TOOLTIP','A special field type is meant to group form elements. The name field is the header section.');
define('TEXT_NAV_FORMS_FIELDS_DISPLAY_RULES','Display Fields Rules');
define('TEXT_FORMS_FIELDS_DISPLAY_RULES','Rules display fields in the form');
define('TEXT_BUTTON_ADD_NEW_RULE','Add a new rule');
define('TEXT_RULE_FOR_FIELD','Rule for field');
define('TEXT_FORMS_FIELDS_DISPLAY_RULES_INFO','For fields of type Drop Down you have the ability to customize the display of fields, depending on the selected list values. <a href="https://docs.rukovoditel.net/index.php?p=64" target="_blank">Read more</a>');
define('TEXT_DISPLAY_FIELDS','Display Fields');
define('TEXT_HIDE_FIELDS','Hide Fields');
define('TEXT_SELECT_FIELD_VALUES','Select field values');
define('TEXT_EDIT_FIELDS','Edit fields');
define('TEXT_FIELDTYPE_RANDOM_VALUE','Random value');
define('TEXT_FIELDTYPE_RANDOM_VALUE_TOOLTIP','Generates a random value from the specified characters');
define('TEXT_VALUE_LENGTH','Value Length');
define('TEXT_CHARACTERS','Characters');
define('TEXT_CHARACTERS_TIP','By default uses only numbers. Enter your characters which will generate value.');
define('TEXT_SPLIT_VALUE','Split value');
define('TEXT_SPLIT_VALUE_INFO','You can split the value into several parts. Enter the number of parts.');
define('TEXT_SPLIT_VALUE_CHAR','Divider');
define('TEXT_SPLIT_VALUE_CHAR_INFO','По умолчанию "-"');
define('TEXT_START_ROW','Start Row');
define('TEXT_START_ROW_TIP','In the value you can add start and end');
define('TEXT_END_ROW','End Row');
define('TEXT_INTERNAL_FIELD_NOTE','Reserved field in the system.');
define('TEXT_RECORD_NOT_FOUND','Record Not Found');
define('TEXT_FILE_NOT_FOUND','File Not Found');
define('TEXT_DISPLAY_AS_COUNTER','Display as counter');
define('TEXT_DISPLAY_ICON','Display icon');
define('TEXT_COLOR','Color');
define('TEXT_EXTRA_FIELDS','Extra Field');
define('TEXT_DASHBOARD_REPORT_EXTRA_FIELDS_INFO','Will be calculated the sum for selected fields');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_TITLE','Multilevel Dropdown');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_TOOLTIP','Each level from the list of values is displayed as a separate list');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_LEVEL_SETTINGS','Levels Settings');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_LEVEL_SETTINGS_INFO','Enter the name of the nesting levels from the new line. The first line of the first level, etc.');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_LEVEL_SETTINGS_TIP','For example:<br>&nbsp;&nbsp;Country<br>&nbsp;&nbsp;Zone<br>Or:<br>&nbsp;&nbsp;Country, Select a country<br>&nbsp;&nbsp;Region Select the region');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_VALUE_DISPLAY','Own column for each value');
define('TEXT_FIELDTYPE_DROPDOWN_MULTILEVEL_VALUE_DISPLAY_TIP','By default selected values will be display in single column');
define('TEXT_COLUMNS_IMPORT','Import Columns');
define('TEXT_COLUMNS_IMPORT_INFO','To import a simple list, type 1 - will be imported first column. For import dependent values, such as (country/zone) specify 2. In this case, it will be read first two columns in the file. The values in the rows must not be empty.');
define('TEXT_DASHBOARD_DEFAULT_MSG','<h3 class="page-title">Welcome!</h3><p>This is the main page for your system. It\'s empty now, but you can display various reports and counters.</p><p>In order to display your first report, select  "Reports" on left navigation menu, create report and set option "In Dashboard".</p>');
define('TEXT_DASHBOARD_DEFAULT_ADMIN_MSG','<h3 class="page-title">Welcome to the Rukovoditel – your new assistant in business management!</h3>
<p>This is the main page for your system. It\'s empty now, but you can display various reports and counters.</p>
<p>In order to display your first report, select  "Reports" on left navigation menu, create report and set option "In Dashboard".</p>
<p>Also we recommend you to visit the "<a href="https://docs.rukovoditel.net/index.php" target="_blank">Documentation</a>". There you will find various tips on setting up the system.</p>
<p>Still have questions? You can always contact us!</p>
<p><a href="https://www.rukovoditel.net" target="_blank">www.rukovoditel.net</a></p>');
define('TEXT_FILES_UPLOAD_LIMIT','Upload Limit');
define('TEXT_FILES_UPLOAD_LIMIT_TIP','The maximum number of files that may be uploaded. Leave empty to remove any limit.');
define('TEXT_FILES_UPLOAD_SIZE_LIMIT','File Size Limit');
define('TEXT_FILES_UPLOAD_SIZE_LIMIT_TIP','The maximum upload size allowed in MB.');
define('TEXT_FILE_TOO_LARGE','File Too Large');
define('TEXT_MAXIMUM_UPLOAD_LIMIT','The upload limit for files has been exceeded. Maximum number of files: ');
define('TEXT_COMPLETED','Completed');
define('TEXT_CANCELLED','Cancelled');
define('TEXT_FROM_SESSION_ERROR','Form submitting error. Please try again.');
define('TEXT_ERROR_MESSAGE','Error message');
define('TEXT_UNIQUE_FIELD_VALUE_ERROR_MSG_TIP','An error message is displayed if the field is not unique.');
define('TEXT_ICON','Icon');
define('TEXT_HIDEN_FIELDS','Hidden fields');
define('TEXT_HIDEN_FIELDS_IN_FORM','Hidden fields are not displayed in the form');
define('TEXT_NAV_ITEM_PAGE_CONFIG','Item Page Configuration');
define('TEXT_COLUMNS_SIZE','Columns Size');
define('TEXT_ITEM_PAGE_COLUMNS_SIZE','The Item Page is divided into two columns and you can adjust their size');
define('TEXT_ITEM_DETAILS_POSITION','Item Details');
define('TEXT_ITEM_DETAILS_POSITION_INFO','By default, Item Fields are separated into two columns. You can combine them into one.');
define('TEXT_ONE_COLUMN','One column');
define('TEXT_TWO_COLUMNS','Two columns');
define('TEXT_ITEM_HIDDEN_PAGE_INFO','By default, all fields are displayed.');
define('TEXT_LEFT_COLUMN','Left Column');
define('TEXT_RIGHT_COLUMN','Right Column');
define('TEXT_ITEM_DETAILS_SUM_ENTITIES','To display records from nested entities, just specify the position on the page. Also, you can set up your own list filters for each entity.');
define('TEXT_ITEM_PAGE_PARENT_ITEM','Item page for parent entity');
define('TEXT_HIDE_IN_TOP_MENU','Hide in the top menu');
define('TEXT_TOP_LEVEL','Top Level');
define('TEXT_CALCULATE_AVERAGE_VALUE_INFO','The average value is displayed in the list of records');
define('TEXT_REPORTS_CREATE_ACCESS','Standard Reports');
define('TEXT_UPDATE_SELECTED_ACCESS','Update Selected');
define('TEXT_DELETE_SELECTED_ACCESS','Delete Selected');
define('TEXT_EXPORT_ACCESS','Export');
define('TEXT_EXPORT_SELECTED_ACCESS','Export Selected');
define('TEXT_VIEW_ALL_ACTION_WIDHT_ASSIGNED_ACCESS','Views All. Actions with Assigned');
define('TEXT_ENTITY_ACCESS_INFO_EXTRA','<br>"Views All. Actions with Assigned" allows you to perform an action only with the assigned records.<br>"Update Selected" will be available when the Extension is installed. <a href="https://docs.rukovoditel.net/index.php?p=89" target="_blank">More Details</a>.');
define('TEXT_CONDITION_NOT_EMPTY_VALUE','Not empty value');
define('TEXT_FIELDTYPE_AUTOSTATUS_TITLE','Automatic status');
define('TEXT_FIELDTYPE_AUTOSTATUS_TOOLTIP','After creating the field, create the necessary statuses by clicking on the field name in the field list. The status will be set automatically when creating or editing an entry, depending on the filters configured. <a href="https://docs.rukovoditel.net/index.php?p=16" target="_blank">Read more</a>.');
define('TEXT_FIELDTYPE_AUTOSTATUS_OPTIONS_TIP','For each option, set the filters by clicking on the option name. The value will be set if the recording status matches the installed filters. The status check is performed in the specified sort and if the condition is found, the check is terminated.');
define('TEXT_FILTERS','Filters');
define('TEXT_AUTOUPDATE','Autoupdate');
define('TEXT_DISPLAY_IN_HEADER_AUTOUPDATE_TOOLTIP','Report data will be refreshed each minute. This option increases the load on the server. Use it where you really need it.');
define('TEXT_PREFIX','Prefix');
define('TEXT_SUFFIX','Suffix');
define('TEXT_PREVIEW_IMAGE_SIZE_IN_LISTING','Image width in listing');
define('TEXT_MARK_AS_READ','Mark as read');
define('TEXT_DISPLAY_NUMBER_OF_ITEMS_OPEN_REPORT','Displaying %s. Go to report <i class="fa fa-angle-right"></i>');
define('TEXT_DISABLE_CHECK_FOR_UPDATES','Disable check for updates');
define('TEXT_EXAMPLE','Example');
define('TEXT_DISPLAY_FILE_DATE_ADDED','Show file upload date');
define('TEXT_NEW_FEATURES_FOR_YOUR_BUSINESS','New features for your business');
define('TEXT_ONE_OFF_CHARGE','One-off charge');
define('TEXT_UPDATES_FOR_FREE','All future updates for free');
define('TEXT_FREE_SUPPORT','Free support');
define('TEXT_BUY_EXTENSION','Buy Extension');
define('TEXT_EXTENSION_FEATURES','Extension Features');
define('TEXT_EXTENSION_FEATURES_INFO','The Extension includes a set of reports and tools for better planning and management.');
define('TEXT_EXTENSION_FEATURES_LIST','');
define('TEXT_HIDE_ADMIN','Hide admins');
define('TEXT_ACTION_IMPORT_DATA','Import Data');
define('TEXT_ACTION_UPDATE_DATA','Update Data');
define('TEXT_ACTION_UPDATE_AND_IMPORT_DATA','Update and Import New Rows');
define('TEXT_UPDATE_BY_FIELD','Update by field');
define('TEXT_USE_COLUMN','Use column');
define('TEXT_UPDATE_SETTINGS','Update Settings');
define('TEXT_COUNT_ITEMS_ADDED','Added records');
define('TEXT_COUNT_ITEMS_UPDATED','Updated records');
define('TEXT_SEND_NOTIFICATION','Send notification');
define('TEXT_REGISTRATION_SEND_NOTIFICATION_INFO','Selected users receive email notification when a new user account has been created.');
define('TEXT_SERVER_LOAD','Server load');
define('TEXT_REPORTS_IN_HEADER_MENU','Reports in Header Menu');
define('TEXT_SERVER_LOAD_INFO','Here you can configure the caching functions of the application to reduce the load on the server.');
define('TEXT_USE_CACHE','Use the cache');
define('TEXT_CACHE_LIVETIME','Cache Lifetime');
define('TEXT_CACHE_LIVETIME_INFO','In seconds');
define('TEXT_REPORTS_IN_HEADER_MENU_CACHE_INFO','By default, reports in the top menu are updated each time the page is refreshed, which creates a load on the server when working with a large number of reports and users.');
define('TEXT_CACHE_FOLDER','Cache Folder');

//new defines for version 2.1
define('TEXT_PIVOT_ACCESS_TABLE','Pivot Access Table');
define('TEXT_COPY_ACCESS','Copy Access');
define('TEXT_SELECT_ENTITY_TO_COPY_ACCESS','Select Entities to copy access.');
define('TEXT_COPY_ACCESS_INFO','Existing access rights will be overwritten.');
define('TEXT_USERS_ALERTS','Users Alerts');
define('TEXT_USERS_ALERTS_INFO','On this page you have the ability to create alerts for selected users or groups of users. <a href="https://docs.rukovoditel.net/index.php?p=15" target="_blank">Read more</a>.');
define('TEXT_LOCATION','Location');
define('TEXT_LOCATION_ON_DASHBOARD','On Dashboard');
define('TEXT_LOCATION_ON_ALL_PAGES','On all Pages');
define('TEXT_TITLE','Title');
define('TEXT_ALERT_SUCCESS','Success');
define('TEXT_ALERT_INFO','Info');
define('TEXT_ALERT_WARNING','Warning');
define('TEXT_ALERT_DANGER','Danger');
define('TEXT_DISPLAY_DATE','Display date');
define('TEXT_DB_RESTORE_PROCESS','Restoring Database');
define('TEXT_DB_RESTORE_PROCESS_INFO','This process may take a few minutes, do not close the browser window.<br><br>If an error occurs, restore the database using phpMyAdmin.');
define('TEXT_IF_NOT_ASSIGNED_DISPLY_EVERYONE','If the group and users are not specified, the message will be displayed to everyone.');
define('TEXT_FLOWCHART','Flowchart');
define('TEXT_ENTITIES_FLOWCHART_INFO','The flowchart displays the entities and relationships. In order to save space, links with the reserved "Users" (field types "User" and "Grouped Users") entity is not indicated by an arrow.');
define('TEXT_PUBLIC_REGISTRATION_USER_GROUP_MULTIPLE','If more than one group is specified, users will be able to select the group themselves when registering.');
define('TEXT_HEADING_WIDTH_BASED_CONTENT','Calculate the cell width based on content');
define('TEXT_HEADING_WIDTH_BASED_CONTENT_INFO','By default, the heading cell has a width of 100%');

//new defines for version 2.2
define('TEXT_VALUE','Value');
define('TEXT_CHOICES_VALUE_INFO','The value can be used in formula calculations. <a href="https://docs.rukovoditel.net/index.php?p=25" target="_blank">Read more</a>');
define('TEXT_FIELDS_TYPES_GROUP_NUMERIC','Numeric field');
define('TEXT_FIELDTYPE_JS_FORMULA_TITLE','JS Formula');
define('TEXT_FIELDTYPE_JS_FORMULA_TOOLTIP','The value of this field will be calculated using the formula below. The value is calculated directly in the form of adding a record. You can use JavaScript syntax in the formula.');
define('TEXT_JS_FORMULA_TIP','Use [Field ID] to setup field value in formula. Example: ([36]+[54])/2. Where 36 and 54 are ID of numeric fields. <a href="https://docs.rukovoditel.net/index.php?p=25" target="_blank"><u>Read more.</u></a>');
define('TEXT_JS_FORMULA_ERROR','Error of formula calculation');
define('TEXT_DISPLAY_CHOICES_VALUES','Display option values');
define('TEXT_DISPLAY_CHOICES_VALUES_TIP','The set values for the options will be displayed in the list, for example (+10)');
define('TEXT_NAV_ACCESS_RULES','Access Rules');
define('TEXT_ACCESS_ALLOCATION_RULES','Access allocation rules');
define('TEXT_ACCESS_ALLOCATION_RULES_INFO','On this page you have the ability to configure user access depending on the values of the selected field. <a href="https://docs.rukovoditel.net/index.php?p=28" target="_blank"><u>Read more.</u></a>');
define('TEXT_ADD_FIELD','Add field');
define('TEXT_ACCESS_RULES_FOR_FIELD','Access allocation rules for field "%s"');
define('TEXT_ACCESS_RULES_FOR_FIELD_INFO','Configure access rules for selected field values.');
define('TEXT_ACCESS_RULES_SELECT_ACCESS','If no values are selected, users will have view-only access.');
define('TEXT_ACCESS_RULES_FIELDS_VIEW_ONLY_ACCESS','Select the fields to view-only access.');
define('TEXT_USE_DEFAULT_IF_NOT_SELECTED','If value not selected then it will be using default settings.');
define('TEXT_FIELDTYPE_TODO_LIST_TITLE','To-do list');
define('TEXT_FIELDTYPE_TODO_LIST_TOOLTIP','A special type of field that allows you to create a to-do list (sub-tasks) within a single task. Each sub-task is entered from the new line of the text field. The * at the beginning of the line means that the sub-task is completed. <a href="https://docs.rukovoditel.net/index.php?p=26" target="_blank"><u>Read more</u></a>.');
define('TEXT_AUTO_ADD_COMMENT','Automatically add a comment');
define('TEXT_OPEN_COMMENT_FORM','Open the comment form');
define('TEXT_FIELDTYPE_TODO_LIST_USE_COMMENTS_INFO','Use comments when checked in the list');
define('TEXT_FOR_SUCCESSFUL_CHECK','Text for a successful mark');
define('TEXT_FOR_UNCHECK','Text to unmark');
define('TEXT_SELECT_REPORTS','Selected report');
define('TEXT_SORT_ITEMS_IN_LIST','To sort items in the list, simply drag and drop them.');
define('TEXT_REPORTS_GROUPS','Reports groups');
define('TEXT_REPORTS_GROUPS_INFO','Group reports by a specific entity or data and display them on a separate page. <a href="https://docs.rukovoditel.net/index.php?p=68" target="_blank"><u>Read more.</u></a>');
define('TEXT_SECTIONS','Sections');
define('TEXT_CONFIGURE_DASHBOARD_SECTION_INFO','Each section consists of two columns for reports.');
define('TEXT_ADD_SECTION','Add Section');
define('TEXT_REPORT_ALREADY_ASSIGNED','This report is already in use.');
define('TEXT_RELATED_ENTITIES_BY_FIELD_ENTITY','Related entities by Entity field');
define('TEXT_RELATED_ENTITIES_BY_FIELD_ENTITY_INFO','To display records from related entities, simply specify a position on the page. You can also set up your own list filters for each entity.');
define('TEXT_FIELDTYPE_PARENT_VALUE_TITLE','Value from parent entity');
define('TEXT_FIELDTYPE_PARENT_VALUE_TOOLTIP','This field type is intended to display a value from the parent entity. Note that this field type can not be used in formulas. To use a value from a parent entity in a formula, use the SELECT function.');
define('TEXT_LDAP_FIRSTNAME','Attribute "First Name"');
define('TEXT_LDAP_FIRSTNAME_NOTE','Example: givenname');
define('TEXT_LDAP_LASTNAME','Attribute "Last Name"');
define('TEXT_LDAP_LASTNAME_NOTE','Example: sn');
define('TEXT_USE_LDAP_LOGIN_ONLY','Use LDAP login only');
define('TEXT_LDAP_GROUP_FILTER','LDAP Filter');
define('TEXT_LDAP_GROUP_FILTER_INFO','When using LDAP, the new user will be automatically placed in this group if his account satisfies this filter.');

//new defines for version 2.3
define('TEXT_ADD_COMMENT_CREATE_RELATED_ITEM','Add comment when create related item');
define('TEXT_ADD_COMMENT_DELETE_RELATED_ITEM','Add comment when delete relation.');
define('TEXT_ADD_COMMENT_WITHOUT_NOTIFICATION','Add comment without notification');
define('TEXT_ADD_COMMENT_WITH_NOTIFICATION','Add comment with notification');
define('TEXT_FIELDTYPE_MYSQL_QUERY_TITLE','MySQL query');
define('TEXT_FIELDTYPE_MYSQL_QUERY_TOOLTIP','A special type of field for creating a custom MySQL query to the selected entity. <a href="https://docs.rukovoditel.net/index.php?p=24" target="_blank"><u>Read more.</u></a>.');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_ENTITY','Select from entity');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_ENTITY_TOOLTIP','Select the entity to which the MySQL query will be built');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_QUERY','Select field');
define('TEXT_FIELDTYPE_MYSQL_QUERY_SELECT_QUERY_TIP','Specify the field to be selected in the query.<br>For example: [12]. You can use the MySQL functions.');
define('TEXT_FIELDTYPE_MYSQL_QUERY_WHERE_QUERY','Condition');
define('TEXT_FIELDTYPE_MYSQL_QUERY_WHERE_QUERY_TIP','Using the fields ID , specify the conditions for what should be selected in the query. For example: [50]=[12]. You can use the MySQL functions.');
define('TEXT_FIELDTYPE_MYSQL_QUERY_DINAMIC_QUERY','Perform dynamically');
define('TEXT_FIELDTYPE_MYSQL_QUERY_DINAMIC_QUERY_INFO','By default, the query is performed when adding/editing a record. By setting this option, the query will be executed directly when viewing the record.');
define('TEXT_HIDE_ADD_BUTTON_RULES','Hide the "Add" button');
define('TEXT_HIDE_ADD_BUTTON_RULES_INFO','Set filters for entity "%s", where the "Add" button will be hidden for entity "%s".');
define('TEXT_FIELDTYPE_IMAGE_MAP_TITLE','Image Map');
define('TEXT_FIELDTYPE_IMAGE_MAP_TOOLTIP','This is special field type for displaying your custom maps, floor plans, creating custom marker labels on map and more. After creating the field, click on the name and add map choices and upload your image for each choice. <a href="https://docs.rukovoditel.net/index.php?p=18" target="_blank"><u>Read more.</u></a>.');
define('TEXT_MAP_SETTINGS','Map settings');
define('TEXT_IMAGE','Image');
define('TEXT_IMAGE_MAP_FILENAME_INFO','Load the image that will be used to build the map.<br><b>Note:</b> Changing map image may cause that positions of map elements may not fit into new map image');
define('TEXT_IMAGE_MAP_FILENAME_DESCRIPTION','Map image minimum size is 512x512px.');
define('TEXT_FIELDTYPE_IMAGE_MAP_BACKGROUND_COLOR_INFO','The markers on the map will use the background from the list values. You can also load your icon to each value of the list.');
define('TEXT_FIELDTYPE_IMAGE_MAP_OPTIONS_TIP','For top level options, upload the image to be used on the map.');
define('TEXT_ICONS','Icons');
define('TEXT_FIELDTYPE_IMAGE_MAP_ICONS_TIP','Upload icons in size 24x24. <a href="https://www.iconfinder.com" target="_blank">Search for icons</a>');
define('TEXT_EXT_PB_USER_AGREEMENT_TEXT','The link to the page "User agreement"');
define('TEXT_EXT_PB_USER_AGREEMENT_TEXT_INFO','Add the text with link to "User agreement" page on your site. The form displays extra required option which the user has to set before sending the form.');
define('TEXT_FIELDTYPE_MIND_MAP_TITLE','Mind map');
define('TEXT_FIELDTYPE_MIND_MAP_TOOLTIP','Special field type to build mind map. A mind map is a diagram used to visually organize information. A mind map is hierarchical and shows relationships among pieces of the whole. <a href="https://docs.rukovoditel.net/index.php?p=19" target="_blank"><u>Read more.</u></a>');
define('TEXT_MIND_MAP_START_TIP','Press ‘Tab’ to Insert Child, ‘Enter’ to Insert Sibling Node.');
define('TEXT_SAVE','Save');
define('TEXT_RESET','Reset');
define('TEXT_RESET_MAP_CONFIRM','Reset your current map and start a new one?');
define('TEXT_LAYOUT','Layout');
define('TEXT_SHAPE','Shape');
define('TEXT_NUMBER','Number');
define('TEXT_SUM','Sum');
define('TEXT_AVERAGE','Average');
define('TEXT_MINIMUM','Minimum');
define('TEXT_MAXIMUM','Maximum');
define('TEXT_ON_TOP','Top');
define('TEXT_ON_BOTTOM','Bottom');
define('TEXT_ON_RIGHT','Right');
define('TEXT_ON_LEFT','Left');
define('TEXT_GRAPH','Graph');
define('TEXT_TREE','Tree');
define('TEXT_MAP','Map');
define('TEXT_INHERIT','Inherit');
define('TEXT_AUTOMATIC','Automatic');
define('TEXT_BOX','Box');
define('TEXT_ELLIPSE','Ellipse');
define('TEXT_UNDERLINE','Underline');
define('TEXT_INSERT_CHILD','Insert a child');
define('TEXT_INSERT_SIBLING','Insert a sibling');
define('TEXT_EDIT','Edit');
define('TEXT_SET_VALUE','Set value');
define('TEXT_CENTER_MAP','Center map');
define('TEXT_ERROR_HEADING_FIELD_ONLY_INPUT_SUPPORT','Use the input field type as the Heading');
define('TEXT_START','Start');
define('TEXT_LISGIN_CONFIGURATION_INFO','On this page, you can customize the appearance of the list of records. <a href="https://docs.rukovoditel.net/index.php?p=65" target="_blank"><u>Read more.</u></a>');
define('TEXT_TABLE','Table');
define('TEXT_LIST','List');
define('TEXT_GRID','Grid');
define('TEXT_MOBILE','Mobile');
define('TEXT_NOT_REQUIRED_FIELD','Not required field');
define('TEXT_DISPLAY_FIELD_NAMES','Display field names');
define('TEXT_ALIGN','Align');
define('TEXT_ALIGN_LEFT','Left');
define('TEXT_ALIGN_CENTER','Center');
define('TEXT_ALIGN_RIGHT','Right');
define('TEXT_DISPLAY_AS','Display as');
define('TEXT_INLINE_LIST','Inline List');
define('TEXT_SECTION_WIDHT_TIP','Enter percent or pixels. Eg. 100% or 150px. Default is auto.');
define('TEXT_GRID_WIDHT_INFO','Enter the cell min. width in pixels.<br>For example: 250. The number of cells per row will be calculated automatically depending on the width of the screen.');
define('TEXT_IMPORT','Import');
define('TEXT_LDAP_INFO','This feature enables LDAP authentication and creates users in a database that successfully authenticate. <a href="https://docs.rukovoditel.net/index.php?p=9" target="_blank"><u>Read more.</u></a>');
define('TEXT_FIELDTYPE_DAYS_DIFFERENCE_TITLE','Days difference');
define('TEXT_FIELDTYPE_DAYS_DIFFERENCE_TOOLTIP','A special type of field that calculates the difference in days between two dates. <a href="https://docs.rukovoditel.net/index.php?p=88" target="_blank"><u>Read more.</u></a>');
define('TEXT_HOLIDAYS','Holidays');
define('TEXT_START_DATE','Start date');
define('TEXT_END_DATE','End date');
define('TEXT_EXCLUDE_LAST_DAY','Exclude last day');
define('TEXT_EXCLUDE_WEEK_DAYS','Exclude week days');
define('TEXT_EXCLUDE_HOLIDAYS','Exclude holidays');
define('TEXT_CURRENT_DATE','Current date');
define('TEXT_FIELDTYPE_HOURS_DIFFERENCE_TITLE','Hours difference');
define('TEXT_FIELDTYPE_HOURS_DIFFERENCE_TOOLTIP','A special type of field that calculates the difference in hours between two dates. <a href="https://docs.rukovoditel.net/index.php?p=88" target="_blank"><u>Read more.</u></a>');
define('TEXT_WORKING_HOURS','Working hours');
define('TEXT_WORKING_HOURS_INFO','Only working hours will be using to calculate difference.');
define('TEXT_HOLIDAYS_INFO','Holiday dates can be excluded when calculating the difference of days. <a href="https://docs.rukovoditel.net/index.php?p=88" target="_blank"><u>Read more.</u></a>');
define('TEXT_LOGIN_AS','Login as <b>%s</b>');
define('TEXT_LOGIN_BACK_AS_ADMIN','Login back as admin');

//new defines for version 2.4
define('TEXT_FIELDTYPE_BOOLEAN_CHECKBOX_TITLE','Boolean Checkbox Field');
define('TEXT_DISPLAY_IN_LISTING','Display in listing');
define('TEXT_COUNT_RELATED_ITEMS','Count of related records');
define('TEXT_LIST_RELATED_ITEMS','List of related records');
define('TEXT_HEADING_PATTER_IN_LINSING','Heading template in listing');
define('TEXT_HIDE_FIELD_IF_NO_RECORDS','Hide field if no records');
define('TEXT_HIDE_BUTTONS','Hide buttons');
define('TEXT_CHANGE_STRUCTURE','Change Structure');
define('TEXT_CHANGE_STRUCTURE_INFO','Note: this operation will cause changes to the records for the selected entity. We recommend to do  database backup before start.');
define('TEXT_MOVE_ENTITY','Move Entity');
define('TEXT_MOVE_TO_PARETN_ITEM_INFO','All records will be moved to selected item.');
define('TEXT_ENTITY_STRUCTURE_CHANGED','Entity structure changed.');
define('TEXT_FIELDTYPE_AUTO_INCREMENT_TITLE','Auto-increment');
define('TEXT_FIELDTYPE_AUTO_INCREMENT_TOOLTIP','When you add a new record, the field value is incremented by one. The field in the form is displayed as an input field and the value can be adjusted.');
define('TEXT_FIELDTYPE_TEXT_PATTERN_STATIC','Static text by pattern');
define('TEXT_FIELDTYPE_TEXT_PATTERN_STATIC_TOOLTIP','Special field that allows you to display text in a specified pattern. The value is generated when a record is added/modified. It is possible to search by value.');
define('TEXT_TOOLTIP_ON_ITEM_PAGE','Tooltip on item page');
define('TEXT_DISPLAY_ON_ITEM_PAGE','Display on item page');
define('TEXT_EXTRA','Extra');
define('TEXT_EMAIL_SUBJECT','Email Subject');
define('TEXT_ENCRYPT_FILE_NAME','Encrypt file name');
define('TEXT_ENCRYPT_FILE_NAME_TIP','By default filename encrypted for security reason.');
define('TEXT_FIELDTYPE_DAYS_DIFFERENCE_DINAMIC_INFO','By default, the difference is calculated when you add/edit a record. Use this option for dynamic calculation with current date.');
define('TEXT_USERS_LOGIN_LOG','Users Login Log');
define('TEXT_IP','IP');
define('TEXT_LOGIN_ATTEMPT','Login attempt');
define('TEXT_SUCCESSFUL_LOGIN','Successful login');
define('TEXT_FIELDTYPE_USER_LAST_LOGIN_DATE','Last login date');
define('TEXT_DELETE_DATA','Delete Data');
define('TEXT_FIELDTYPE_YEARS_DIFFERENCE_TITLE','Years difference');
define('TEXT_FIELDTYPE_YEARS_DIFFERENCE_TOOLTIP','A special type of field that calculates the difference in years between two dates. <a href="https://docs.rukovoditel.net/index.php?p=88" target="_blank"><u>Read more.</u></a>');
define('TEXT_CALCULATE_DIFFERENCE_DAYS','Calculate the difference in days');
define('TEXT_FIELDTYPE_PHONE','Phone');
define('TEXT_FIELDTYPE_PHONE_TOOLTIP','A special field type to enter phone number. Can be configured to make calls. <a href="https://docs.rukovoditel.net/index.php?p=62" target="_blank"><u>Read more.</u></a>');
define('TEXT_INPUT_FIELD_PHONE_MASK_TIP','For example: +1(999)999-99-99<br>
<ul>  
  <li>9 - Represents a numeric character (0-9)</li>  
</ul>');
define('TEXT_FIELDTYPE_DATE_UPDATED_TITLE','Date Updated');
define('TEXT_MIN_VALUE','Minimum value');
define('TEXT_MIN_VALUE_WARNING','Please enter a value greater than or equal to {0}.');
define('TEXT_MAX_VALUE','Maximum value');
define('TEXT_MAX_VALUE_WARNING','Please enter a value less than or equal to {0}.');
define('TEXT_MIN_MAX_VALUE_TIP','Enter a number or enter [ID] of the field to apply the field value to the rule.');
define('TEXT_PHONE','Phone');
define('TEXT_ERROR_REQUIRED_DIGITS','Please enter an integer.');
define('TEXT_DASHBOARD_CONFIGURATION','Dashboard Configuration');
define('TEXT_DASHBOARD_CONFIGURATION_INFO','You can add info blocks or pages on home page. In info block you can output information about current user. <a href="https://docs.rukovoditel.net/index.php?p=13" target="_blank"><u>Read more.</u></a>');
define('TEXT_ADD_INFO_BLOCK','Add info block');
define('TEXT_ADD_PAGE','Add page');
define('TEXT_ADD_INFO_SECTIONS_INFO','Information blocks can be combined into sections.');
define('TEXT_COLUMNS','Columns');
define('TEXT_POSITION','Position');
define('TEXT_DASHBOARD_BLOCK_SECTION_INFO','[user_name] - user name');
define('TEXT_AUTHORIZED_USER_BY_DEFAULT','Authorized user by default');
define('TEXT_AUTHORIZED_USER_BY_DEFAULT_INFO','When you add a new record, the authorized user is assigned by default');
define('TEXT_HELP_SYSTEM','Help system');
define('TEXT_HELP_SYSTEM_INFO','Create informational pages and announcements for a specific entity. <a href="https://docs.rukovoditel.net/index.php?p=27" target="_blank"><u>Read more.</u></a>');
define('TEXT_ADD_ANNOUNCEMENT','Add announcement');
define('TEXT_HIDE_COUNT_OF_RECORDS','Hide count of records');
define('TEXT_SUM_BY_FIELD','Sum by field');
define('TEXT_COUNTER_SUM_BY_FIELD_INFO','By default, the count of records is displayed.');
define('TEXT_ITEMS_LISTING','Items Listing');
define('TEXT_HELP','Help');
define('TEXT_ALLOW_LOGIN_FOR_USERS','Allow login for users');
define('TEXT_ALLOWED_EXTENSIONS','Allowed Extensions');
define('TEXT_ALLOWED_EXTENSIONS_TIP','Enter extensions by comma, eg: gif,jpg,sql,zip');
define('TEXT_ENTITIES_PAGE_INFO','Rukovoditel allows you build your own database by adding new entities and relationships. <a href="https://docs.rukovoditel.net/index.php?p=12" target="_blank"><u>Read more.</u></a>');
define('TEXT_SHOW_USERS','Show users');
define('TEXT_IN_LISTING','In listing');
define('TEXT_IN_ITEM_PAGE','In item page');
define('TEXT_FIELDTYPE_GROUPEDUSERS_SHOW_USERS_TIP','A list of users will be displayed along with the group name.');
define('TEXT_SHOW_USERS_ACCESS_GROUP','Show access group');
define('TEXT_CHANGE_COL_WIDTH_IN_LISTIN','Change column width in the listing');
define('TEXT_ENTITY_MOVE_TO','Move to');

//new defines for version 2.5
define('TEXT_VALUE_VIEW_ONLY_INFO','The value of a field is read-only.');
define('TEXT_FIELDTYPE_AUTO_INCREMENT_SEPARATE_NUMBERING','Separate numbering for each parent record');
define('TEXT_MAPS','Maps');
define('TEXT_FIELDTYPE_GOOGLE_MAP_TITLE','Google Map');
define('TEXT_FIELDTYPE_GOOGLE_MAP_TOOLTIP','Field to display the marker on the map. The coordinates of the marker are determined automatically by the entered address. <a href="https://docs.rukovoditel.net/index.php?p=17" target="_blank"><u>Read more.</u></a>');
define('TEXT_API_KEY','API Key');
define('TEXT_FIELDTYPE_GOOGLE_MAP_API_KEY_TIP','You have to get an API key using the Google Cloud Platform Console. GeoLocation API and Map Embed API should be enabled. <a href="https://developers.google.com/maps/documentation/javascript/get-api-key#quick-guide" target="_blank">Quick guide.</a>');
define('TEXT_ADDRESS','Address');
define('TEXT_ADDRESS_PATTERN_INOF','Use one or more fields where the address is stored. <br>Example: "[36], [54]" where the 36 and 54 - fields ID.');
define('TEXT_WIDTH_INPUT_TIP','Enter percent or pixels. Eg. 100% or 250px');
define('TEXT_HEIGHT_INPUT_TIP','Enter height in pixels. Eg. 250px');
define('TEXT_FIELDTYPE_INPUT_PROTECTED_TITLE','Input Protected Field');
define('TEXT_FIELDTYPE_INPUT_PROTECTED_TOOLTIP','Special field type to protect individual user information. This field allows you to limit and hidden data in full such as the identification number by disclosing only last 3-4 characters.');
define('TEXT_REPLACE_WITH_SYMBOL','Replace with symbol');
define('TEXT_DISCLOSE_NUMBER_FIRST_LETTERS','Disclose number of first letters');
define('TEXT_DISCLOSE_NUMBER_LAST_LETTERS','Disclose number of last letters');
define('TEXT_FIELDTYPE_INPUT_PROTECTED_USERS_GROUPS_TIP','Select users groups which will see full value.');
define('TEXT_FILTERS_PANELS','Filters Panels');
define('TEXT_DEFAULT_FILTER_PANEL','Default Filter Panel');
define('TEXT_DEFAULT_FILTER_PANEL_INFO','You can disable this panel or show it to certain groups of users. <a href="https://docs.rukovoditel.net/index.php?p=67" target="_blank"><u>Read more.</u></a>');
define('TEXT_QUICK_FILTERS_PANELS','Quick Filters Panels');
define('TEXT_QUICK_FILTER_PANEL_INFO','These panels are used to filter data by the most frequently used parameters. You can create a horizontal or vertical quick filter panel. In the panel settings you can choose which fields and values will be used for filters. <a href="https://docs.rukovoditel.net/index.php?p=67" target="_blank"><u>Read more.</u></a>');
define('TEXT_CONFIGURE','Configure');
define('TEXT_FILTERS_PANELS_ACCESS_INFO','Select the user groups that will have access to the filters panel. By default, the panel is available to all users.');
define('TEXT_HORIZONTAL','Horizontal');
define('TEXT_VERTICAL','Vertical');
define('TEXT_FIELDS_CONFIGURATION','Fields Configuration');
define('TEXT_PANES_FILTERS_FIELDS_CONFIGURATION_INFO','Add the fields that you want to use in the filter pane.');
define('TEXT_PANEL','Panel');
define('TEXT_RESET_FILTERS','Reset Filters');
define('TEXT_ENTER_LIST_HEIGHT','Enter the list height in pixels.');
define('TEXT_CLEAR','Clear');
define('TEXT_EXCLUDE_VALUES','Exclude values');
define('TEXT_ACTIVE_FILTERS','Active filters');
define('TEXT_ACTIVE_FILTERS_INFO','Items listing is updated automatically after you select a filter value.');
define('TEXT_USER','User');
define('TEXT_OK','OK');
define('TEXT_BUTTON_REPLY','Reply');
define('TEXT_BUTTON_FORWARD','Forward');
define('TEXT_WARNING_ITEM_HAS_SUB_ITEM','<b>Warning:</b> entity "%s" has sub-entities.<br>All records from sub-entities will be deleted.');
define('TEXT_CONFIRM_DELETE','Confirm Deletion');
define('TEXT_BUTTON_EMPTY','Empty');
define('TEXT_FIELDTYPE_TAGS_TITLE','Tags');
define('TEXT_FIELDTYPE_TAGS_TOOLTIP','A special field type that allows you to select an existing option or dynamically create a new option in the drop-down list. <a href="https://docs.rukovoditel.net/index.php?p=79" target="_blank"><u>Read more.</u></a>');
define('TEXT_NO_RESULTS_FOUND','No results found');
define('TEXT_SEARCHING','Searching…');
define('TEXT_LOADING_MORE_RESULTS','Loading more results…');
define('TEXT_RESULTS_COULD_NOT_BE_LOADED','The results could not be loaded.');
define('TEXT_AUTOMATICALLY_CREATE_TAG','Automatically create tag');
define('TEXT_AUTOMATICALLY_CREATE_TAG_TIP','When you enter a space or coma in the search bar, the tag will be added automatically.');
define('TEXT_FIELDTYPE_ENTITY_AJAX_TITLE','Entity drop-down list (ajax)');
define('TEXT_FIELDTYPE_ENTITY_AJAX_TOOLTIP','A special field for lists with a large amount of data. Allows you to link to an existing entity. It is displayed as a drop-down list in which data is loaded ajax request.');
define('TEXT_SEARCH_BY_FIELDS','Search by fields');
define('TEXT_SEARCH_BY_FIELDS_INFO','Specify the fields which will be using to search items. By default, the heading is used.');
define('TEXT_COPY_VALUES','Copy values');
define('TEXT_COPY_FIELD_VALUES_INFO','The values from the selected record can be copied to the current form.<br>Specify field relationships on a new line in the format:<br> 
[13]=[14]<br>
13 - field id of the selected entity<br>
14 - field id of the current entity');
define('TEXT_DELETE_BY_CREATOR_ONLY','Delete by creator only');
define('TEXT_FIELDTYPE_USER_ROLES_TITLE','User roles');
define('TEXT_FIELDTYPE_USER_ROLES_TOOLTIP','This field type allows you to assign a user to a record and set an additional access role for nested entities. After creating the field, click the field name and add the required user roles. <a href="https://docs.rukovoditel.net/index.php?p=77" target="_blank"><u>Read more.</u></a>');
define('TEXT_USER_ROLES','User roles');
define('TEXT_USER_ROLES_ENTITIES_WARNING','User roles can be configured for nested entities only. There are no sub-entities in the current entity.');
define('TEXT_USER_ROLES_INFO','After adding a role, click on the name and configure access. If only one role is added, it will be automatically assigned to the user.');
define('TEXT_USER_ROLES_ACCESS_INFO','Select the required entities and configure access. When you assign a role to a user, the access rules for the selected entities will replace the basic rules for the user group.');
define('TEXT_ROLE','Role');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_TITLE','Entity Multilevel Dropdown');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_TOOLTIP','The list of values is generated based on the selected value from the parent entity.');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_SELECT_ENTITY_TOOLTIP','Select a last  level entity in entity tree.');
define('TEXT_HIDE_PLUS_BUTTON','Hide "+" button"');
define('TEXT_FIELDS_EXPORT','Fields Export');
define('TEXT_FIELDS_EXPORT_INFO','This functionality is designed to transfer the configured fields to another application. The selected fields are exported to an xml file. To import generated file, use the button <i class="fa fa-upload"></i>');
define('TEXT_IMPORT_FIELDS','Import fields');
define('TEXT_CONTINUE','Continue');
define('TEXT_IMPORTED_FIELDS','Imported fields: %s');
define('TEXT_IMPORT_FIELDS_INFO','To import the fields, use the xml file obtained when exporting the fields.<br><b>Note:</b> The imported fields will have new ID. <br> If the field ID are used in formulas, the formulas need to be corrected.');
define('TEXT_SELECT_USER_GROUPS_COMMON_INFO','Select the user groups that will have access. By default, all users have access.');
define('TEXT_LISTING_CONFIG_ACCESS_INFO','Select user groups that will have access to the listing configuration. By default, listing fields configuration  is available for all users.');
define('TEXT_CURRENT_USER','Current user');
define('TEXT_FIELDTYPE_MONTHS_DIFFERENCE_TITLE','Months difference ');
define('TEXT_FIELDTYPE_MONTHS_DIFFERENCE_TOOLTIP','A special type of field that calculates the difference in months between two dates.');
define('TEXT_CALCULATE_DIFFERENCE_DAYS_INFO','When calculating the date difference, the number of days will be taken into account.');
define('TEXT_HIDE_DROPDOWN','Hide dropdown');
define('TEXT_FIELDTYPE_USERS_APPROVE_TITLE','Approve');
define('TEXT_FIELDTYPE_USERS_APPROVE_TOOLTIP','This field type allows you select list of user to approve record  or add signature.');
define('TEXT_BUTTON_TITLE','Button title');
define('TEXT_APPROVE','Approve');
define('TEXT_CONFIRMATION_WINDOW','Confirmation window');
define('TEXT_CONFIRMATION_TEXT','Confirmation text');
define('TEXT_ADD_COMMENT','Add comment');
define('TEXT_COMMENT_TEXT','Comment text');
define('TEXT_APPROVED','Approved');
define('TEXT_FIELDTYPE_USERS_APPROVE_FILTERS_INFO','Set filters for which the "Approve" button will be available.');
define('TEXT_BUTTON','Button');
define('TEXT_ALL_USERS_APPROVED','All users approved');
define('TEXT_ALL_USERS_APPROVED_INFO','Select the action that will be run once all users has be approved record. The action can be configured in <a href="https://docs.rukovoditel.net/index.php?p=31" target="_blank">Extension->Automatic Actions</a>.');
define('TEXT_PLEASE_PROVIDE_SIGNATURE','Please provide your signature.');
define('TEXT_SIGNATURE','Signature');
define('TEXT_WIDTH_IN_ITEM_PAGE','Width on item page');
define('TEXT_WIDTH_IN_ITEM_PAGE_INFO','The width of the image in pixels when displayed on the item page.');
define('TEXT_WIDTH_IN_PRINT_PAGE','Width on print page');
define('TEXT_WIDTH_IN_PRINT_PAGE_INFO','The width of the image in pixels when displayed on the print page.');
define('TEXT_DELETION','Deletion');
define('TEXT_CONFIRM_DELETION','Confirm deletion');
define('TEXT_ALLOWS_DELETE_IF_HAS_DELETE_ACCESS','Allow delete if user have have access to delete a record');
define('TEXT_RULES','Rules');

//new defines for version 2.6
define('TEXT_ACCESS_CONFIGURATION','Access Configuration');
define('TEXT_SEND_NOTIFICATION_TO_ASSIGNED_ONLY','Send notifications to assigned users only');
define('TEXT_SEND_COMMENTS_NOTIFICATION_TO_ASSIGNED_INFO','By default, when you add a comment, notifications are sent to the assigned users on the record, as well as to the users who just post comment to ther record.');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_TITLE','Google Map Directions');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_TOOLTIP','Field to display multiple markers on the map. The coordinates of the markers are determined automatically by the entered addresses. The specified markers can be used to create a route. <a href="https://docs.rukovoditel.net/index.php?p=17" target="_blank"><u>Read more.</u></a>');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_ADDRESS_TIP','Enter multiple addresses with a new line.');
define('TEXT_MARKER','Marker');
define('TEXT_LABEL','Label');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_LABEL_TIP','You can enter labels for each address in new line.');
define('TEXT_LABEL_COLOR','Label Color');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_ICONS_TIP','You can set icon for each address. Enter icon http url in new line.');
define('TEXT_DIRECTIONS','Directions');
define('TEXT_MODE','Mode');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_MODE_TIP','To enable calculate directions, you need to specify which transportation mode to use. <a href="https://developers-dot-devsite-v2-prod.appspot.com/maps/documentation/javascript/directions?hl=ru#DirectionsRequests" target="_blank">Read More.</a><br><b>Note:</b> the Directions API must be enabled in console.cloud.google.com<br><b>Please note:</b> custom markers and icons do not work with directions.');
define('TEXT_OPTIMIZE_WAYPOINTS','Optimize Waypoints');
define('TEXT_PROVIDE_ROUTE_ALTERNATIVES','Provide Route Alternatives');
define('TEXT_AVOID_FERRIES','Avoid Ferries');
define('TEXT_AVOID_HIGHWAYS','Avoid Highways');
define('TEXT_AVOID_TOLLS','Avoid Tolls');
define('TEXT_TRIM_VALUE','Trim Value');
define('TEXT_TRIM_VALUE_INFO','Can be used if you need to get part of field value.');
define('TEXT_TRIM_VALUE_EXAMPLE','Will be used PHP function <a href="https://www.php.net/manual/en/function.substr.php" target="_blank">substr</a>.<br>In input field enter int $start [, int $length ]. For example: 0,4 ');
define('TEXT_DISPLAY_LAST_COMMENT_IN_LISTING','Display the last comment in listing');
define('TEXT_DISPLAY_LAST_COMMENT_IN_LISTING_INFO','The comment will be displayed along with the heading field.');
define('TEXT_FIELDTYPE_GOOGLE_MAP_DIRETIONS_FIELDS_IN_POPUP_TIP','Enter a field ID, separated by commas, for each address from a new line.');
define('TEXT_FORM_CONFIG_INFO','On this page, you have the ability to sort the fields in the form, create additional tabs for the fields, and embed your JavaScript code into the form. <a href="https://docs.rukovoditel.net/index.php?p=64" target="_blank">Read More</a>.');
define('TEXT_ADD_JAVASCRIPT','Add JavaScript');
define('TEXT_JAVASCRIPT_IN_FORM','JavaScript in form');
define('TEXT_JAVASCRIPT_IN_FORM_INFO','The JavaScript you enter will be embedded in the form when it is displayed.');
define('TEXT_JAVASCRIPT_ONSUBMIT_FORM_INFO','The entered JavaScript will be called on the onSubmit. To stop submit form use: return false;');
define('TEXT_DEFAULT_NOTIFICATIONS','Default notifications');
define('TEXT_DEFAULT_NOTIFICATIONS_INFO','By default, notifications are sent to all assigned users. Use the Users field type to assign users to a record.<br>For more flexible notification settings, use the <a href="https://docs.rukovoditel.net/index.php?p=75" target="_blank">Mail sending rules</a>.');
define('TEXT_HIDE_CHECKBOXES_IF_NO_ACCESS','Hide checkboxes if no field edit access');
define('TEXT_BODY','Body');
define('TEXT_END','End');
define('TEXT_ALLOW_PUBLIC_ACCESS','Allow public access');
define('TEXT_ENTER_TEXT_PATTERN_INFO_SHORT','Use [Field ID] to set the value of the field in the template.');
define('TEXT_PUBLIC_ATTACHMENTS_TIP','Select attachments for which you want to allow public access via a special link. This option is used when exporting data via api, xml, etc.');
define('TEXT_DISPLAY_ONLY_ASSIGNED_RECORDS','Display assigned items only');
define('TEXT_DISPLAY_ONLY_ASSIGNED_RECORDS_INFO','This rule will be applied if the selected entity has "' . TEXT_VIEW_ASSIGNED_ACCESS . '" rights');
define('TEXT_HIDE_COUNTER_IF_NO_RECORDS','Hide counter if there are no records');
define('TEXT_HEADER','Header');
define('TEXT_FOOTER','Footer');
define('TEXT_FIELDTYPE_DYNAMIC_DATE_TITLE','Dynamic Date');
define('TEXT_FIELDTYPE_DYNAMIC_DATE_TOOLTIP','This type of field is used to display the date, which is calculated by the MySQL formula. The formula should return a value in timestamp. Set the date format in the field settings. This field type can be used in a calendar report or Gantt chart.');
define('TEXT_GLOBAL_LIST_USER_NOTES','This option is used if the list is applied to the "Grouped users" field type.');
define('TEXT_RECORDS_VISIBILITY','Records Visibility');
define('TEXT_RECORDS_VISIBILITY_INFO','Configure the visibility of records depending on the value of the fields. <a href="https://docs.rukovoditel.net/index.php?p=82" target="_blank"><u>Read more.</u></a>');
define('TEXT_ADD_RULE','Add Rule');
define('TEXT_USERS_GROUPS_FOR_RULE_TIP','Select the user groups for which this rule will be applied.');
define('TEXT_LINKED_ENTITIES','Linked Entities');
define('TEXT_RECORDS_VISIBILITY_LINK_ENTITY_INFO','Establish a relationship between the Users entity and the current entity using fields that use the same global list or entity.');
define('TEXT_MAX_DATE','Maximum selectable date');
define('TEXT_MIN_DATE','Minimum selectable date');
define('TEXT_OVERDUE_DATES','Overdue dates');
define('TEXT_DISABLE_COLOR','Disable Color');
define('TEXT_DISABLE_COLOR_BY_FIELD_TIP','Select the field and values at which color selection will be disabled.');
define('TEXT_HIDE_ACCESS_GROUP','Hide group name from users list');
define('TEXT_USE_GROUPS_TIP','Only users from the specified groups will be displayed.');
define('TEXT_FIELDTYPE_ENTITY_MULTILEVEL_PARENT_FIELD_TIP','The value of the parent will be used from the selected field.');
define('TEXT_DIGITAL_SIGNATURE_LOGIN','Login by digital signature');
define('TEXT_DIGITAL_SIGNATURE_LOGIN_INFO','Select the digital signature module that will be used for user login.');
define('TEXT_EXTENSION_REQUIRED','Extension required.');
define('TEXT_FIELDTYPE_ACCESS_GROUP_TITLE','User access groups');
define('TEXT_FIELDTYPE_ACCESS_GROUP_TOOLTIP','You can assign a user access group to a record. All users in the selected group will have access to the record.');
define('TEXT_FIELDTYPE_ACCESS_GROUP_USERS_GROUP_TIP','Only the specified groups will be displayed.');
define('TEXT_FIELDTYPE_ACCESS_GROUP_NOTIFY_TIP','Notifications will be sent to all users of the selected groups. It is recommended enable the "Send via Cron" option in your email settings.');
define('TEXT_MULTI_LEVEL_IMPORT','Multi level import');
define('TEXT_MULTI_LEVEL_IMPORT_INFO','Specify the entity of the required nesting level to import multi-level records.');
define('TEXT_MULTI_LEVEL_IMPORT_NOTE','A mandatory rule is to bind each field marked as a Heading for each level of the entity tree.');
define('TEXT_MULTI_LEVEL_IMPORT_HEADING_ERROR','Error: missing header field for entity "%s".');
define('TEXT_HEADING','Heading');
define('TEXT_FIELDTYPE_SIGNATURE_TITLE','Signature');
define('TEXT_FIELDTYPE_SIGNATURE_TOOLTIP','Field allows add Name and Signature. Not related to app users.');
define('TEXT_ENTER_YOUR_NAME','Enter your name');
define('TEXT_DISPLAY_PROGRESS_BAR','Display progress bar');
define('TEXT_MIN_WIDTH','Minimum width');
define('TEXT_PROGRESS_BAR','Progress bar');
define('TEXT_FIELDTYPE_STAGES_TITLE','Stages');
define('TEXT_FIELDTYPE_STAGES_TOOLTIP','A special type of field that displays the stages panel on the record page, with which you can quickly move to the next stage. After creating the field, click on the name to create the stages. <a href="https://docs.rukovoditel.net/index.php?p=81" target="_blank"><u>Read more.</u></a>');
define('TEXT_STAGES_PANEL','Stages panel');
define('TEXT_TRIANGLE','Triangle');
define('TEXT_RECTANGLE','Rectangle');
define('TEXT_DOT','Dot');
define('TEXT_CIRCLE','Circle');
define('TEXT_ACTION_BY_CLICK','Action by click');
define('TEXT_ALLOW_CHANGING_VALUE','Allow changing the value');
define('TEXT_ALLOW_CHANGING_VALUE_NEXT_STEP','Allow changing the value only for the next step');
define('TEXT_ACTIVE_ITEM_COLOR','Active item color');
define('TEXT_CONFIRM_ACTION','Confirm action');
define('TEXT_FIELDTYPE_STAGES_ACTION_TIP','You have the opportunity to connect the process of automation to every stage. If a process is selected, it will be executed when you go to this stage.');
define('TEXT_FIELDTYPE_IFRAME_TITLE','Iframe');
define('TEXT_FIELDTYPE_IFRAME_TOOLTIP','Simple input field  to enter url that will be opened in iframe.');
define('TEXT_SCROLL_BAR','Scroll bar');
define('TEXT_EXTRA_PARAMS','Extra parameters');
define('TEXT_FIELDTYPE_IFRAME_EXTRA_PARAMS_TIP','Will be included in iframe tag.');
define('TEXT_2STEP_VERIFICATION','2-Step Verification');
define('TEXT_2STEP_VERIFICATION_INFO','If enabled, the user, when entering the system, in addition to the credentials, will need to enter a special code sent to the user by email or SMS. <a href="https://docs.rukovoditel.net/index.php?p=83" target="_blank"><u>Read more.</u></a>');
define('TEXT_ENABLE_TEXT_2STEP_VERIFICATION','Enable 2-Step Verification');
define('TEXT_SEND_CODE_BY','Send code by');
define('TEXT_2STEP_VERIFICATION_EMAIL_SUBJECT','Login to ' . $_SERVER['HTTP_HOST'] . ' ' . i18n_date('d F Y h:i',time()));
define('TEXT_2STEP_VERIFICATION_EMAIL_BODY','Login code: %s');
define('TEXT_CODE_FROM_EMAIL','Code from Email');
define('TEXT_CODE_FROM_EMAIL_INFO','Verification code was sent to %s');
define('TEXT_INCORRECT_CODE','Incorrect code');
define('TEXT_CODE_FROM_SMS','Code from SMS');
define('TEXT_CODE_FROM_SMS_INFO','You have been sent SMS message with a code to the phone %s');
define('TEXT_MAIN_FEATURES','Main features');
define('TEXT_EXT_FEATURES_LIST','Сalendar,Gantt Chart,Funnel Chart,Kanban Board,Pivot Table,Online chat,Tickets by email,Telephony,SMS,API');
define('TEXT_FULL_LIST_OF_FEATURES','Full list of features');

//new defines for version 2.7
define('TEXT_FIELDTYPE_BARCODE_ACCEPTED_TYPE_TIP','All types support different character sets or have mandatory lengths. Please see wikipedia for supported chars and lengths per type. Most used types are CODE_128 and CODE_39. Because of the best scanner support, variable length and most chars supported.');
define('TEXT_OVERDUE_DATE_WITH_TIME','Overdue dates with time');
define('TEXT_FIELDTYPE_TIME','Time');
define('TEXT_FIELDTYPE_TIME_TOOLTIP','Field for entering the time in the format: "hours":"minutes". In the database, the field value is stored in minutes.');
define('TEXT_CALENDAR','Calendar');
define('TEXT_SUM_IN_COMMENTS','Sum in comments');
define('TEXT_SUM_IN_COMMENTS_INFO','The value of this field will be equal to the sum of the values entered in the comments.');
define('TEXT_DISPLAY_PREFIX_SUFFIX_IN_FORM','Display Prefix/Suffix in form');
define('TEXT_PHP_EXTENSION_REQUIRED','<b>Error:</b> PHP "<b>%s</b>" extension required! Check php.ini on your server to enable this extension.');
define('TEXT_LOGIN_BY_PHONE_NUMBER','Login by phone number');
define('TEXT_ALLOW_LOGIN_BY_PHONE_NUMBER','Allow login by phone number');
define('TEXT_ALLOW_LOGIN_BY_PHONE_NUMBER_INFO','An additional link to the "' . TEXT_LOGIN_BY_PHONE_NUMBER . '" page will appear on the login page.');
define('TEXT_ENTER_YOUR_PHONE_NUMBER','Enter your phone number');
define('TEXT_FIELDTYPE_ENTITY_MYSQL_QUERY_TIP','Add a MySQL condition to select only certain records. <a href="https://docs.rukovoditel.net/index.php?p=78" target="_blank"><u>Read more.</u></a>');
define('TEXT_HIGHLIGHT_ROW','Highlight row');
define('TEXT_LISGIN_HIGHLIGHT_ROW_INFO','Set the field values that will highlight the entire row in the list. These rules apply to all listings.<br>You can setup several rules and they will apply by sort order.');
define('TEXT_FIELD_ACCESS_INFO','Configure access to the field for each user group.');
define('TEXT_YOU_CANT_DELETE_YOURSELF','You can\'t delete yourself');
define('TEXT_DOCUMENTATION','Documentation');
define('TEXT_NEWS','News');
define('TEXT_USER_ACTIVATION','User activation');
define('TEXT_BY_EMAIL','By Email');
define('TEXT_MANUALLY','Manually');
define('TEXT_PUBLIC_REGISTRATION_TIP','Your customers will be able to register themselves on the app. <a href="https://docs.rukovoditel.net/index.php?p=14" target="_blank"><u>Read more.</u></a>');
define('TEXT_USER_ACTIVATION_AUTOMATIC_TIP','The user account is automatically activated after registration and the user immediately gets access to the app.');
define('TEXT_USER_ACTIVATION_BY_EMAIL_TIP','The account is activated after confirming the Email address. A special code will be sent to the user\'s Email address.');
define('TEXT_USER_ACTIVATION_MANUALLY_TIP','The administrator manually checks and activates new users .');
define('TEXT_REGISTRATION_SUCCESS_PAGE','Registration Success Page');
define('TEXT_EMAIL_ABOUT_USER_ACTIVATION','Email about user activation');
define('TEXT_REGISTRATION_SUCCESS_PAGE_HEADING','You account is created and inactive at the moment');
define('TEXT_REGISTRATION_SUCCESS_PAGE_DESCRIPTION','Your account will be verified soon. You will receive notifications about the activation of your account.');
define('TEXT_USER_ACTIVATION_EMAIL_SUBJECT','Your account is activated');
define('TEXT_USER_ACTIVATION_EMAIL_BODY','Login to app using next link %s');
define('TEXT_EMAIL_VERIFICATION_EMAIL_SUBJECT','Email Verification');
define('TEXT_EMAIL_VERIFICATION_EMAIL_BODY','
<p>Hello,<br>
You received this email because you entered your email address when registering on site "<a href="' . url_for('users/login','',true) . '">' . CFG_APP_NAME . '</a>".</p>
<p>We need to make sure that you are the owner of this Email address.</p>
<p>To confirm your email address, enter the following code: <b>%s</b></p>
<p><small>This email was sent automatically.<br>
If you think you received it by mistake, just ignore it.</small></p>
');
define('TEXT_EMAIL_VERIFIED','Email Verified');
define('TEXT_EMAIL_NOT_VERIFIED','Email Not Verified');
define('TEXT_CHECK_SPAM_FOLDER','If the message does not arrive within five minutes, check the Spam folder.');
define('TEXT_RESEND_CODE','Resend Code');
define('TEXT_RESEND_CODE_TIP','To resend the code, enter your username/password.');
define('TEXT_CHNAGE_EMAIL','Change Email Address');
define('TEXT_HIDE_COORDINATES_IN_FORM','Hide coordinates in form');
define('TEXT_FIELDTYPE_DIGITAL_SIGNATURE_TITLE','Digital signature');
define('TEXT_FIELDTYPE_DIGITAL_SIGNATURE_TOOLTIP','This field is to work with digital signature modules that allows you sign documents. <a href="https://docs.rukovoditel.net/index.php?p=84" target="_blank"><u>Read more.</u></a>');
define('TEXT_MODULE','Module');
define('TEXT_FIELDS_FOR_SIGNATURE','Fields for signature');
define('TEXT_DIGITAL_SIGNATURE','Digital signature');
define('TEXT_FIELDTYPE_AJAX_REQUEST_TITLE','Ajax Request');
define('TEXT_FIELDTYPE_AJAX_REQUEST_TOOLTIP','A special type of field that allows you to perform calculations on the fly in the form of a record. <a href="https://docs.rukovoditel.net/index.php?p=99" target="_blank"><u>Read more.</u></a>');
define('TEXT_PHP_CODE','PHP code');
define('TEXT_DEBUG_MODE','Debug Mode');
define('TEXT_CUSTOM_CSS','Custom CSS');
define('TEXT_CUSTOM_CSS_INFO','You can add your own styles that will override the default CSS.');
define('TEXT_FILE_PATH','File path');
define('TEXT_ERRRO_FOLDER_NOT_WRITABLE','Error: folder "%s" is not writable!');
define('TEXT_SET_FILTERS_FOR_ACTION_BUTTON','Set filters for which the action button will be available.');
define('TEXT_HIDE_ENTITY_NAME','Hide entity name');
define('TEXT_TOOLBAR','Toolbar');
define('TEXT_IN_ONE_LINE','In one line');
define('TEXT_FIELDTYPE_USERS_AJAX_TITLE','Users Ajax');
define('TEXT_FIELDTYPE_USERS_AJAX_TOOLTIP','This field is displayed as a drop-down list, where data is loaded with an ajax request. The selected users from the list are assigned to the record and receive notifications.');
define('TEXT_DISPLAY_SETTINGS','Display Settings');
define('TEXT_HIDE_EMPTY_BLOCK','Hide empty block');
define('TEXT_HIDE_BY_CONDITION','Hide by condition');
define('TEXT_HIDE_BY_CONDITION_SUBENTITY_INFO','Set filters for the parent entity in which the nested entity will be hidden on the record page.');
define('TEXT_SEPARATOR','Separator');
define('TEXT_RECORDS_VISIBILITY_EMPTY_VALUE_INFO','An empty value check will be added for the selected fields.');
define('TEXT_FIELDTYPE_ITEMS_BY_QUERY_TITLE','List of records by MySql query');
define('TEXT_FIELDTYPE_ITEMS_BY_QUERY_TOOLTIP','A special type of field that displays a list of records by a custom database query. <a href="https://docs.rukovoditel.net/index.php?p=101" target="_blank"><u>Read more.</u></a>');
define('TEXT_NUMBER_OF_RECORDS','Number of records');
define('TEXT_TOTAL','Total');
define('TEXT_ERROR_REQUIRED_URL','Please enter a valid URL.');
define('TEXT_EXTENSION_REQUIRED_URL','<a href="https://www.rukovoditel.net/extension.php" target="_blank">' . TEXT_EXTENSION_REQUIRED . '</a>');










